/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.PropertyCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a,\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0006\"\b\b\u0000\u0010\b*\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0015\u0010\u0012\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00130\u0001*\u00020\u000f\u001a\u0015\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00130\u0001*\u00020\u000f\u00a8\u0006\u0015"}, d2={"collectDefinedNames", "", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "scope", "Lcom/google/dart/compiler/backend/js/ast/JsNode;", "collectFunctionReferencesInside", "", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectJsProperties", "Ljava/util/IdentityHashMap;", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "collectNamedFunctions", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "collectReferencedNames", "collectUsedNames", "collectFreeVariables", "Lorg/jetbrains/annotations/NotNull;", "collectLocalVariables", "kotlin-compiler"})
public final class CollectUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsName> collectFunctionReferencesInside(@NotNull JsNode scope) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Iterable $receiver$iv = CollectUtilsKt.collectReferencedNames(scope);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JsName it = (JsName)element$iv$iv;
            if (!(MetadataProperties.getStaticRef(it) instanceof JsFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    private static final Set<JsName> collectReferencedNames(JsNode scope) {
        Set<JsName> references = CollectionUtilsKt.IdentitySet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null) {
                    Collection collection = this.$references;
                    collection.add(name);
                }
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectUsedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Set<JsName> references = CollectionUtilsKt.IdentitySet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null && nameRef.getQualifier() == null) {
                    this.$references.add(name);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Collection collection = this.$references;
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                CollectionsKt.addAll(collection, iterable);
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Map names2 = new HashMap();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Map $names;

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
                JsName jsName = x.getName();
                Intrinsics.checkExpressionValueIsNotNull(jsName, "x.name");
                this.addNameIfNeeded(jsName);
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                JsName name;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression expression = x.getExpression();
                if (expression instanceof JsFunction && (name = ((JsFunction)expression).getName()) != null) {
                    this.addNameIfNeeded(name);
                }
                super.visitExpressionStatement(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            private final void addNameIfNeeded(JsName name) {
                String ident = name.getIdent();
                JsName nameCollected = (JsName)this.$names.get(ident);
                boolean bl = nameCollected == null || nameCollected == name;
                if (_Assertions.ENABLED && !bl) {
                    String string = "ambiguous identifier " + name;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Map map2 = this.$names;
                String string = ident;
                Intrinsics.checkExpressionValueIsNotNull(string, "ident");
                String string2 = string;
                JsName jsName = name;
                map2.put(string2, jsName);
            }
            {
                this.$names = $captured_local_variable$0;
            }
        }.accept(scope);
        return CollectionsKt.toSet(names2.values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectFreeVariables(@NotNull JsFunction $receiver) {
        void var3_4;
        Collection<JsName> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsNode jsNode = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "body");
        Set<JsName> set = CollectUtilsKt.collectUsedNames(jsNode);
        JsNode jsNode2 = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsNode2, "body");
        Iterable iterable = $receiver.getParameters();
        Set<JsName> set2 = SetsKt.minus(set, (Iterable)CollectUtilsKt.collectDefinedNames(jsNode2));
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            JsName jsName = it.getName();
            collection.add(jsName);
        }
        collection = (List)var3_4;
        return SetsKt.minus(set2, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectLocalVariables(@NotNull JsFunction $receiver) {
        void var3_4;
        Collection<JsName> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsNode jsNode = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "body");
        Iterable iterable = $receiver.getParameters();
        Set<JsName> set = CollectUtilsKt.collectDefinedNames(jsNode);
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            JsName jsName = it.getName();
            collection.add(jsName);
        }
        collection = (List)var3_4;
        return SetsKt.plus(set, (Iterable)collection);
    }

    @NotNull
    public static final IdentityHashMap<JsName, JsExpression> collectJsProperties(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        PropertyCollector collector2 = new PropertyCollector();
        collector2.accept(scope);
        return collector2.getProperties();
    }

    @NotNull
    public static final IdentityHashMap<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        IdentityHashMap<JsName, JsFunction> namedFunctions = new IdentityHashMap<JsName, JsFunction>();
        Map map2 = CollectUtilsKt.collectJsProperties(scope);
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            JsFunction function;
            JsFunction jsFunction;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            JsName name = (JsName)entry2.getKey();
            Map.Entry entry3 = entry;
            JsExpression value = (JsExpression)entry3.getValue();
            Object object = value;
            if (object instanceof JsFunction) {
                jsFunction = (JsFunction)value;
            } else {
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(value);
                jsFunction = inlineMetadata != null ? inlineMetadata.getFunction() : null;
            }
            if ((function = jsFunction) == null) continue;
            object = namedFunctions;
            JsFunction jsFunction2 = function;
            object.put(name, jsFunction2);
        }
        return namedFunctions;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass, @NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        InstanceCollector<JsNode> instanceCollector = new InstanceCollector<JsNode>(klass, false);
        InstanceCollector<JsNode> $receiver = instanceCollector;
        $receiver.accept(scope);
        return $receiver.getCollected();
    }
}

