/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.StringTools;

public abstract class SpellingCheckRule
extends Rule {
    public static final String LANGUAGETOOL = "LanguageTool";
    public static final String LANGUAGETOOL_FX = "LanguageToolFx";
    protected final Language language;
    private static final String SPELLING_IGNORE_FILE = "/hunspell/ignore.txt";
    private static final String SPELLING_FILE = "/hunspell/spelling.txt";
    private static final String SPELLING_PROHIBIT_FILE = "/hunspell/prohibit.txt";
    private final Set<String> wordsToBeIgnored = new HashSet<String>();
    private final Set<String> wordsToBeProhibited = new HashSet<String>();
    private final CachingWordListLoader wordListLoader = new CachingWordListLoader();
    private List<DisambiguationPatternRule> antiPatterns = new ArrayList<DisambiguationPatternRule>();
    private boolean considerIgnoreWords = true;
    private boolean convertsCase = false;

    public SpellingCheckRule(ResourceBundle messages, Language language) {
        super(messages);
        this.language = language;
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    @Override
    public abstract RuleMatch[] match(AnalyzedSentence var1) throws IOException;

    @Override
    public boolean isDictionaryBasedSpellingRule() {
        return true;
    }

    @Override
    public void reset() {
    }

    public void addIgnoreTokens(List<String> tokens) {
        this.wordsToBeIgnored.addAll(tokens);
    }

    public void setConsiderIgnoreWords(boolean considerIgnoreWords) {
        this.considerIgnoreWords = considerIgnoreWords;
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        ArrayList<String> moreSuggestions = new ArrayList<String>();
        if (("Languagetool".equals(word) || "languagetool".equals(word)) && !suggestions.contains(LANGUAGETOOL)) {
            moreSuggestions.add(LANGUAGETOOL);
        }
        return moreSuggestions;
    }

    protected List<String> getAdditionalSuggestions(List<String> suggestions, String word) {
        return Collections.emptyList();
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        for (AnalyzedTokenReadings token : tokens) {
            words.add(token.getToken());
        }
        return this.ignoreWord(words, idx);
    }

    protected boolean ignoreWord(String word) throws IOException {
        if (!this.considerIgnoreWords) {
            return false;
        }
        if (word.endsWith(".") && !this.wordsToBeIgnored.contains(word)) {
            return this.isIgnoredNoCase(word.substring(0, word.length() - 1));
        }
        return this.isIgnoredNoCase(word);
    }

    private boolean isIgnoredNoCase(String word) {
        return this.wordsToBeIgnored.contains(word) || this.convertsCase && this.wordsToBeIgnored.contains(word.toLowerCase(this.language.getLocale()));
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        return this.ignoreWord(words.get(idx));
    }

    public boolean isConvertsCase() {
        return this.convertsCase;
    }

    public void setConvertsCase(boolean convertsCase) {
        this.convertsCase = convertsCase;
    }

    protected boolean isUrl(String token) {
        return WordTokenizer.isUrl(token);
    }

    protected boolean isEMail(String token) {
        return WordTokenizer.isEMail(token);
    }

    protected void init() throws IOException {
        for (String ignoreWord : this.wordListLoader.loadWords(this.getIgnoreFileName())) {
            this.addIgnoreWords(ignoreWord, this.wordsToBeIgnored);
        }
        for (String ignoreWord : this.wordListLoader.loadWords(this.getSpellingFileName())) {
            this.addIgnoreWords(ignoreWord, this.wordsToBeIgnored);
        }
        for (String prohibitedWord : this.wordListLoader.loadWords(this.getProhibitFileName())) {
            this.wordsToBeProhibited.addAll(this.expandLine(prohibitedWord));
        }
    }

    protected String getIgnoreFileName() {
        return this.language.getShortName() + SPELLING_IGNORE_FILE;
    }

    public String getSpellingFileName() {
        return this.language.getShortName() + SPELLING_FILE;
    }

    protected String getProhibitFileName() {
        return this.language.getShortName() + SPELLING_PROHIBIT_FILE;
    }

    protected boolean isProhibited(String word) {
        return this.wordsToBeProhibited.contains(word);
    }

    protected void filterSuggestions(List<String> suggestions) {
        for (int i = 0; i < suggestions.size(); ++i) {
            if (!this.isProhibited(suggestions.get(i))) continue;
            suggestions.remove(i);
        }
    }

    protected void addIgnoreWords(String line, Set<String> wordsToBeIgnored) {
        wordsToBeIgnored.add(line);
    }

    protected List<String> expandLine(String line) {
        return Collections.singletonList(line);
    }

    public void acceptPhrases(List<String> phrases) {
        ArrayList<List<PatternToken>> antiPatterns = new ArrayList<List<PatternToken>>();
        for (String phrase : phrases) {
            String[] parts = phrase.split(" ");
            ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
            int i = 0;
            boolean startsLowercase = false;
            for (String part : parts) {
                String uppercased;
                if (i == 0 && !(uppercased = StringTools.uppercaseFirstChar(part)).equals(part)) {
                    startsLowercase = true;
                }
                patternTokens.add(new PatternTokenBuilder().csToken(part).build());
                ++i;
            }
            antiPatterns.add(patternTokens);
            if (!startsLowercase) continue;
            antiPatterns.add(this.getTokensForSentenceStart(parts));
        }
        this.antiPatterns = this.makeAntiPatterns(antiPatterns, this.language);
    }

    private List<PatternToken> getTokensForSentenceStart(String[] parts) {
        ArrayList<PatternToken> ucPatternTokens = new ArrayList<PatternToken>();
        int j = 0;
        for (String part : parts) {
            if (j == 0) {
                String uppercased = StringTools.uppercaseFirstChar(part);
                ucPatternTokens.add(new PatternTokenBuilder().posRegex("SENT_START").build());
                ucPatternTokens.add(new PatternTokenBuilder().csToken(uppercased).build());
            } else {
                ucPatternTokens.add(new PatternTokenBuilder().csToken(part).build());
            }
            ++j;
        }
        return ucPatternTokens;
    }

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns;
    }

    protected int startsWithIgnoredWord(String word, boolean caseSensitive) {
        Optional<String> match;
        if (caseSensitive) {
            match = this.wordsToBeIgnored.stream().filter(s -> word.startsWith((String)s)).max(Comparator.naturalOrder());
        } else {
            String lowerCaseWord = word.toLowerCase();
            match = this.wordsToBeIgnored.stream().filter(s -> lowerCaseWord.startsWith(s.toLowerCase())).max(Comparator.naturalOrder());
        }
        return match.isPresent() ? match.get().length() : 0;
    }
}

