require 'spec_helper'
require 'msf/core'

RSpec.describe Msf::Exploit::Remote::FirefoxAddonGenerator do
  subject(:instance) do
    klass.new.tap { |instance|
      allow(instance).to receive(:datastore).and_return(datastore)
      allow(instance).to receive(:framework).and_return(framework)
      allow(instance).to receive(:payload).and_return(payload)
      allow(instance).to receive(:regenerate_payload).and_return(payload)
    }
  end

  let(:cli) { double }
  let(:datastore) { { 'TARGET' => 0 } }
  let(:framework) { double(:nops => nil) }
  let(:jar) { double(:pack => '@JAR@', :build_manifest => nil) }

  let(:klass) {
    context_described_class = described_class

    Class.new(Msf::Exploit::Remote) do
      include Msf::Exploit::Remote::BrowserExploitServer
      include context_described_class
    end
  }

  let(:payload) { double(:encoded => '@EXE@', :encoded_jar => jar) }

  it { is_expected.to respond_to :generate_addon_xpi }

  describe '#generate_addon_xpi' do
    subject(:xpi) {
      instance.generate_addon_xpi(cli)
    }

    it { is_expected.to be_a Rex::Zip::Archive }
  end
end
