/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.action.ClearSelectionAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.ToggleGridAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class ActionsToolBar
extends AbstractToolBar {
    private ToggleGridAction toggleGridAction;
    private UndoRedoManager undoManager;

    public ActionsToolBar() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(resourceBundleUtil.getString(this.getID() + ".toolbar"));
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        if (this.editor != null && this.undoManager != null) {
            this.removePropertyChangeListener(this.getEventHandler());
        }
        this.editor = drawingEditor;
        if (this.editor != null && this.undoManager != null) {
            this.init();
            this.setDisclosureState(this.prefs.getInt(this.getID() + ".disclosureState", 1));
            this.addPropertyChangeListener(this.getEventHandler());
        }
    }

    public void setUndoManager(UndoRedoManager undoRedoManager) {
        if (this.editor != null && undoRedoManager != null) {
            this.removePropertyChangeListener(this.getEventHandler());
        }
        this.undoManager = undoRedoManager;
        if (this.editor != null && undoRedoManager != null) {
            this.init();
            this.setDisclosureState(this.prefs.getInt(this.getID() + ".disclosureState", 1));
            this.addPropertyChangeListener(this.getEventHandler());
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                Preferences preferences = PreferencesUtil.userNodeForPackage(this.getClass());
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                JButton jButton = new JButton(this.undoManager.getUndoAction());
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.setText(null);
                resourceBundleUtil.configureToolBarButton(jButton, "edit.undo");
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridx = 0;
                jPanel.add((Component)jButton, gridBagConstraints);
                jButton = new JButton(this.undoManager.getRedoAction());
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.setText(null);
                resourceBundleUtil.configureToolBarButton(jButton, "edit.redo");
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 3, 0, 0);
                jPanel.add((Component)jButton, gridBagConstraints);
                jButton = ButtonFactory.createPickAttributesButton(this.editor, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                resourceBundleUtil.configureToolBarButton(jButton, "attributesPick");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jButton, gridBagConstraints);
                jButton = ButtonFactory.createApplyAttributesButton(this.editor, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                resourceBundleUtil.configureToolBarButton(jButton, "attributesApply");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jButton, gridBagConstraints);
                JPopupButton jPopupButton = new JPopupButton();
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setItemFont(UIManager.getFont("MenuItem.font"));
                resourceBundleUtil.configureToolBarButton(jPopupButton, "actions");
                jPopupButton.add(new DuplicateAction());
                jPopupButton.addSeparator();
                AbstractSelectedAction abstractSelectedAction = new GroupAction(this.editor, new SVGGroupFigure());
                jPopupButton.add(abstractSelectedAction);
                this.disposables.add(abstractSelectedAction);
                abstractSelectedAction = new UngroupAction(this.editor, new SVGGroupFigure());
                jPopupButton.add(abstractSelectedAction);
                this.disposables.add(abstractSelectedAction);
                jPopupButton.addSeparator();
                jPopupButton.add(new CutAction());
                jPopupButton.add(new CopyAction());
                jPopupButton.add(new PasteAction());
                jPopupButton.add(new DeleteAction());
                jPopupButton.addSeparator();
                jPopupButton.add(new SelectAllAction());
                abstractSelectedAction = new SelectSameAction(this.editor);
                jPopupButton.add(abstractSelectedAction);
                this.disposables.add(abstractSelectedAction);
                jPopupButton.add(new ClearSelectionAction());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                break;
            }
        }
        return jPanel;
    }

    public ToggleGridAction getToggleGridAction() {
        return this.toggleGridAction;
    }

    private void initComponents() {
    }

    @Override
    protected String getID() {
        return "actions";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }
}

