/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class ProportionalLayout
implements LayoutManager2 {
    private Component topComponent;
    private Component bottomComponent;
    private int gap;

    public ProportionalLayout() {
        this(5);
    }

    public ProportionalLayout(int n) {
        this.gap = n;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == Constraints.TOP) {
            this.topComponent = component;
        } else if (object == Constraints.BOTTOM) {
            this.bottomComponent = component;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        throw new IllegalArgumentException("Use addLayoutComponent with a Constraints object");
    }

    public void removeLayoutComponent(Component component) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        boolean bl;
        Insets insets = container.getInsets();
        int n = container.getWidth() - insets.left - insets.right;
        int n2 = container.getHeight() - insets.top - insets.bottom;
        boolean bl2 = bl = this.topComponent != null && this.topComponent.getParent() != null;
        if (bl) {
            this.topComponent.setBounds(insets.left, insets.top, n, Math.min(this.topComponent.getPreferredSize().height, n2));
        }
        if (this.bottomComponent != null && this.bottomComponent.getParent() != null) {
            int n3;
            Dimension dimension = this.bottomComponent.getPreferredSize();
            int n4 = n2;
            int n5 = insets.top;
            if (bl) {
                n3 = this.topComponent.getHeight() + this.gap;
                n4 -= n3;
                n5 += n3;
            }
            n3 = n4 * dimension.width / dimension.height;
            int n6 = insets.left;
            if (n3 > n) {
                n3 = n;
                int n7 = n4;
                n4 = n3 * dimension.height / dimension.width;
                n5 += (n7 - n4) / 2;
            } else {
                n6 += (n - n3) / 2;
            }
            this.bottomComponent.setBounds(n6, n5, n3, n4);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        boolean bl;
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = this.topComponent != null && this.topComponent.getParent() != null;
        if (bl) {
            dimension = this.topComponent.getMinimumSize();
            n = Math.max(n, dimension.width);
            n2 = dimension.height;
        }
        if (this.bottomComponent != null && this.bottomComponent.getParent() != null) {
            dimension = this.bottomComponent.getMinimumSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
            if (bl) {
                n2 += this.gap;
            }
        }
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension;
        boolean bl;
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = this.topComponent != null && this.topComponent.getParent() != null;
        if (bl) {
            dimension = this.topComponent.getMaximumSize();
            n = Math.max(n, dimension.width);
            n2 = dimension.height;
        }
        if (this.bottomComponent != null && this.bottomComponent.getParent() != null) {
            dimension = this.bottomComponent.getMaximumSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
            if (bl) {
                n2 += this.gap;
            }
        }
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        boolean bl;
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = this.topComponent != null && this.topComponent.getParent() != null;
        if (bl) {
            dimension = this.topComponent.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 = dimension.height;
        }
        if (this.bottomComponent != null && this.bottomComponent.getParent() != null) {
            dimension = this.bottomComponent.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
            if (bl) {
                n2 += this.gap;
            }
        }
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Constraints {
        TOP,
        BOTTOM;

    }
}

