/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.charts.xy;

import com.sun.tools.visualvm.charts.xy.SimpleXYChartUtils;
import com.sun.tools.visualvm.charts.xy.XYTooltipModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYTooltipPainter
extends JPanel {
    private static Color BACKGROUND_COLOR = Utils.forceSpeed() ? new Color(80, 80, 80) : new Color(0, 0, 0, 170);
    private JLabel caption;
    private JLabel[] valuePainters;
    private XYTooltipModel model;
    private boolean initialized;

    public XYTooltipPainter(XYTooltipModel model) {
        this.model = model;
        this.initialized = false;
    }

    public void update(List<ItemSelection> selectedItems) {
        if (!this.initialized) {
            this.initComponents();
        }
        int rowsCount = this.model.getRowsCount();
        if (selectedItems.size() != rowsCount) {
            throw new IllegalStateException("Rows and selected items don't match");
        }
        XYItemSelection selection = (XYItemSelection)selectedItems.get(0);
        long timestamp = selection.getItem().getXValue(selection.getValueIndex());
        this.caption.setText(this.model.getTimeValue(timestamp));
        for (int i = 0; i < rowsCount; ++i) {
            XYItemSelection sel = (XYItemSelection)selectedItems.get(i);
            long itemValue = sel.getItem().getYValue(sel.getValueIndex());
            this.valuePainters[i].setText(this.model.getRowValue(i, itemValue));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.caption = new JLabel();
        this.caption.setFont(SimpleXYChartUtils.smallerFont(this.caption.getFont()));
        this.caption.setForeground(Color.WHITE);
        this.caption.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.caption, constraints);
        int count = this.model.getRowsCount();
        this.valuePainters = new JLabel[count];
        for (int i = 0; i < count; ++i) {
            JLabel valueLabel;
            JLabel itemLabel = new JLabel();
            itemLabel.setText(this.model.getRowName(i));
            itemLabel.setFont(SimpleXYChartUtils.smallerFont(itemLabel.getFont()));
            itemLabel.setForeground(Color.WHITE);
            itemLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = i + 1;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)itemLabel, constraints);
            this.valuePainters[i] = valueLabel = new JLabel();
            valueLabel.setFont(SimpleXYChartUtils.smallerFont(valueLabel.getFont()));
            valueLabel.setForeground(Color.WHITE);
            valueLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = i + 1;
            constraints.gridwidth = 1;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)valueLabel, constraints);
            final Dimension ZERO = new Dimension(0, 0);
            JPanel valueSpacer = new JPanel(null){

                public Dimension getPreferredSize() {
                    return ZERO;
                }
            };
            valueSpacer.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = i + 1;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)valueSpacer, constraints);
        }
        this.initialized = true;
    }
}

