/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.marker;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class CompositeMarker
implements Marker {
    private Set delegates = new LinkedHashSet();

    public CompositeMarker() {
    }

    public CompositeMarker(Set set) {
        this();
        this.delegates.addAll(set);
    }

    @Override
    public MarkMapping[] getMappings() {
        HashSet<MarkMapping> hashSet = new HashSet<MarkMapping>();
        for (Marker marker : this.delegates) {
            MarkMapping[] markMappingArray = marker.getMappings();
            hashSet.addAll(Arrays.asList(markMappingArray));
        }
        return hashSet.toArray(new MarkMapping[hashSet.size()]);
    }

    @Override
    public Mark[] getMarks() {
        HashSet<Mark> hashSet = new HashSet<Mark>();
        for (Marker marker : this.delegates) {
            Mark[] markArray = marker.getMarks();
            hashSet.addAll(Arrays.asList(markArray));
        }
        return hashSet.toArray(new Mark[hashSet.size()]);
    }

    public void addMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        this.delegates.add(marker);
    }

    public void addMarkers(Collection collection) {
        if (collection == null) {
            return;
        }
        this.delegates.addAll(collection);
    }

    public void removeMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        this.delegates.remove(marker);
    }

    public void removeMarkers(Collection collection) {
        if (collection == null) {
            return;
        }
        this.delegates.removeAll(collection);
    }
}

