/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search.impl;

import java.util.List;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.netbeans.spi.search.SubTreeSearchOptions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public final class SearchInfoDefinitionUtils {
    private SearchInfoDefinitionUtils() {
    }

    public static SearchInfoDefinition findSearchInfoDefinition(Node node) {
        return SearchInfoDefinitionUtils.getSearchInfoDefinition(node, false);
    }

    public static SearchInfoDefinition getSearchInfoDefinition(Node node) {
        return SearchInfoDefinitionUtils.getSearchInfoDefinition(node, true);
    }

    private static SearchInfoDefinition getSearchInfoDefinition(Node node, boolean bl) {
        SubTreeSearchOptions subTreeSearchOptions;
        SearchInfoDefinition searchInfoDefinition = (SearchInfoDefinition)node.getLookup().lookup(SearchInfoDefinition.class);
        if (searchInfoDefinition != null) {
            return searchInfoDefinition;
        }
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null && (subTreeSearchOptions = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            fileObject = subTreeSearchOptions.getPrimaryFile();
        }
        if (fileObject == null) {
            return null;
        }
        subTreeSearchOptions = SearchInfoDefinitionUtils.findSubTreeSearchOptions(node);
        if (subTreeSearchOptions == null && !bl) {
            return null;
        }
        return SearchInfoDefinitionFactory.createSearchInfo(fileObject, SearchInfoDefinitionUtils.getFiltersForNode(subTreeSearchOptions));
    }

    private static SearchFilterDefinition[] getFiltersForNode(SubTreeSearchOptions subTreeSearchOptions) {
        if (subTreeSearchOptions != null) {
            List<SearchFilterDefinition> list = subTreeSearchOptions.getFilters();
            SearchFilterDefinition[] searchFilterDefinitionArray = new SearchFilterDefinition[list.size()];
            return list.toArray(searchFilterDefinitionArray);
        }
        List<SearchFilterDefinition> list = SearchInfoDefinitionFactory.DEFAULT_FILTER_DEFS;
        return list.toArray(new SearchFilterDefinition[list.size()]);
    }

    private static SubTreeSearchOptions findSubTreeSearchOptions(Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            SubTreeSearchOptions subTreeSearchOptions = (SubTreeSearchOptions)node2.getLookup().lookup(SubTreeSearchOptions.class);
            if (subTreeSearchOptions == null) continue;
            return subTreeSearchOptions;
        }
        return null;
    }
}

