/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.FieldAccessor;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.ImageBuilder;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.ImageExportAction;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.InstanceBuilder;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.openide.util.HelpCtx;

public class ImageDetailProvider
extends DetailsProvider.Basic {
    private static final int CHECKER_SIZE = 8;
    private static final int PREVIEW_BORDER = 4;
    private static final Color CHECKER_BG = Color.LIGHT_GRAY;
    private static final Color CHECKER_FG = Color.DARK_GRAY;

    private static void drawChecker(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(CHECKER_BG);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(CHECKER_FG);
        for (int i = 0; i < n3; i += 8) {
            for (int j = 0; j < n4; j += 8) {
                if ((i / 8 + j / 8) % 2 != 0) continue;
                graphics.fillRect(n + i, n2 + j, Math.min(8, n3 - i), Math.min(8, n4 - j));
            }
        }
    }

    public ImageDetailProvider() {
        super(ImageBuilder.BUILDERS.getMasks(Image.class, String.class));
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        try {
            InstanceBuilder<String> instanceBuilder = ImageBuilder.BUILDERS.getBuilder(instance, String.class);
            if (instanceBuilder != null) {
                return instanceBuilder.convert(new FieldAccessor(heap, ImageBuilder.BUILDERS), instance);
            }
            ImageBuilder.LOGGER.log(Level.FINE, "Unable to get String builder for %s", string);
        }
        catch (FieldAccessor.InvalidFieldException invalidFieldException) {
            ImageBuilder.LOGGER.log(Level.FINE, "Unable to get text for instance", invalidFieldException.getMessage());
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String string, Instance instance, Heap heap) {
        return new ImageView(instance, heap);
    }

    private static class ImageTopComponent
    extends ProfilerTopComponent {
        private static final String HELP_CTX_KEY = "HeapWalker.ImagePreview.HelpCtx";
        private static final HelpCtx HELP_CTX = new HelpCtx("HeapWalker.ImagePreview.HelpCtx");

        ImageTopComponent(Image image, String string, int n) {
            this.setName(BrowserUtils.getSimpleType(string) + "#" + n);
            this.setToolTipText("Preview of " + string + "#" + n);
            this.setLayout(new BorderLayout());
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            ImageDetailProvider.drawChecker(graphics2D, 0, 0, n2, n3);
            graphics2D.drawImage(image, 0, 0, null);
            JScrollPane jScrollPane = new JScrollPane(new JLabel(new ImageIcon(bufferedImage)));
            this.add(jScrollPane, "Center");
            JToolBar jToolBar = new JToolBar();
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            jToolBar.setFloatable(false);
            jToolBar.setName(Bundle.ImageDetailProvider_Toolbar());
            jToolBar.add(new ImageExportAction(image));
            this.add(jToolBar, "North");
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }
    }

    private static class ImageView
    extends DetailsProvider.View
    implements Scrollable {
        private final String instanceName;
        private final int instanceNumber;
        private Image instanceImage = null;
        private JLabel paintLabel;

        public ImageView(Instance instance, Heap heap) {
            super(instance, heap);
            this.instanceName = instance.getJavaClass().getName();
            this.instanceNumber = instance.getInstanceNumber();
            this.addMouseListener(new MouseHandler());
        }

        @Override
        protected void computeView(Instance instance, Heap heap) {
            FieldAccessor fieldAccessor = new FieldAccessor(heap, ImageBuilder.BUILDERS);
            Image image = null;
            JLabel jLabel = null;
            try {
                image = ImageBuilder.buildImageInternal(instance, heap);
            }
            catch (FieldAccessor.InvalidFieldException invalidFieldException) {
                ImageBuilder.LOGGER.log(Level.FINE, "Unable to get text for instance", invalidFieldException.getMessage());
                jLabel = new JLabel(Bundle.ImageDetailProvider_NotSupported(), 0);
                jLabel.setEnabled(false);
            }
            final JLabel jLabel2 = jLabel;
            final Image image2 = image;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageView.this.removeAll();
                    if (jLabel2 != null) {
                        ImageView.this.add((Component)jLabel2, "Center");
                    }
                    ImageView.this.revalidate();
                    ImageView.this.doLayout();
                    ImageView.this.repaint();
                    ImageView.this.instanceImage = image2;
                }
            });
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.instanceImage == null) {
                return;
            }
            int n = graphics.getFontMetrics().getHeight();
            int n2 = graphics.getFontMetrics().getAscent();
            int n3 = this.getWidth() - 8;
            int n4 = this.getHeight() - 12 - 2 * n;
            if (n3 < 1 || n4 < 1) {
                return;
            }
            int n5 = this.instanceImage.getWidth(null);
            int n6 = this.instanceImage.getHeight(null);
            if (n5 < 1 || n6 < 1) {
                return;
            }
            int n7 = n5;
            int n8 = n6;
            int n9 = 1;
            int n10 = (int)Math.ceil((float)n5 / (float)n3);
            int n11 = (int)Math.ceil((float)n6 / (float)n4);
            if (n10 > 1 || n11 > 1) {
                n9 = Math.max(n10, n11);
                n7 = (int)((float)n5 / (float)n9);
                n8 = (int)((float)n6 / (float)n9);
            }
            int n12 = 4 + (n3 - n7) / 2;
            int n13 = 4 + (n4 - n8) / 2;
            ImageDetailProvider.drawChecker(graphics, n12, n13, n7, n8);
            graphics.drawImage(this.instanceImage, n12, n13, n12 + n7, n13 + n8, 0, 0, n5, n6, null);
            graphics.setColor(this.getForeground());
            int n14 = this.getHeight() - this.drawText(graphics, 4, this.getHeight(), Bundle.ImageDetailProvider_Dimension(n5, n6));
            if (n9 != 1) {
                this.drawText(graphics, 4, n14, Bundle.ImageDetailProvider_Zoom(n9));
            }
        }

        private int drawText(Graphics graphics, int n, int n2, String string) {
            if (this.paintLabel == null) {
                this.paintLabel = new JLabel();
            }
            this.paintLabel.setFont(graphics.getFont());
            this.paintLabel.setText(string);
            this.paintLabel.setSize(this.paintLabel.getPreferredSize());
            graphics.translate(n, n2 - this.paintLabel.getHeight());
            this.paintLabel.paint(graphics);
            graphics.translate(-n, this.paintLabel.getHeight() - n2);
            return this.paintLabel.getHeight();
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (this.instanceImage == null) {
                return;
            }
            JMenuItem jMenuItem = new JMenuItem(Bundle.ImageDetailProvider_Action_Show()){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ImageView.this.openNewWindow();
                }
            };
            jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(new ImageExportAction(this.instanceImage));
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private void openNewWindow() {
            if (this.instanceImage == null) {
                return;
            }
            ImageTopComponent imageTopComponent = new ImageTopComponent(this.instanceImage, this.instanceName, this.instanceNumber);
            imageTopComponent.open();
            imageTopComponent.requestActive();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 50;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ImageView.this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ImageView.this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    ImageView.this.openNewWindow();
                }
            }
        }
    }
}

