/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.openide.util.HelpCtx;

public final class ComponentDetailsProvider
extends DetailsProvider.Basic {
    private static final String JLABEL_MASK = "javax.swing.JLabel+";
    private static final String ABSTRACTBUTTON_MASK = "javax.swing.AbstractButton+";
    private static final String JTOOLTIP_MASK = "javax.swing.JToolTip+";
    private static final String JFILECHOOSER_MASK = "javax.swing.JFileChooser+";
    private static final String TABLECOLUMN_MASK = "javax.swing.table.TableColumn+";
    private static final String JPANEL_MASK = "javax.swing.JPanel+";
    private static final String JPROGRESSBAR_MASK = "javax.swing.JProgressBar+";
    private static final String JINTERNALFRAME_MASK = "javax.swing.JInternalFrame+";
    private static final String FRAME_MASK = "java.awt.Frame+";
    private static final String DIALOG_MASK = "java.awt.Dialog+";
    private static final String COMPONENT_MASK = "java.awt.Component+";

    public ComponentDetailsProvider() {
        super(JLABEL_MASK, ABSTRACTBUTTON_MASK, JTOOLTIP_MASK, JFILECHOOSER_MASK, JINTERNALFRAME_MASK, TABLECOLUMN_MASK, JPANEL_MASK, JPROGRESSBAR_MASK, FRAME_MASK, DIALOG_MASK, COMPONENT_MASK);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        boolean bl;
        if (JLABEL_MASK.equals(string) || ABSTRACTBUTTON_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "text", heap);
        }
        if (JTOOLTIP_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "tipText", heap);
        }
        if (JFILECHOOSER_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "dialogTitle", heap);
        }
        if (JINTERNALFRAME_MASK.equals(string) || FRAME_MASK.equals(string) || DIALOG_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "title", heap);
        }
        if (TABLECOLUMN_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "headerValue", heap);
        }
        if (JPROGRESSBAR_MASK.equals(string) && (bl = DetailsUtils.getBooleanFieldValue(instance, "paintString", false))) {
            return DetailsUtils.getInstanceFieldString(instance, "progressString", heap);
        }
        String string2 = ComponentDetailsProvider.getStringField(instance, "displayName", heap);
        if (string2 == null) {
            string2 = ComponentDetailsProvider.getStringField(instance, "label", heap);
        }
        if (string2 == null) {
            string2 = ComponentDetailsProvider.getStringField(instance, "name", heap);
        }
        if (string2 != null && string2.trim().isEmpty()) {
            string2 = null;
        }
        return string2;
    }

    @Override
    public DetailsProvider.View getDetailsView(String string, Instance instance, Heap heap) {
        return new ComponentView(instance, heap);
    }

    private static String getStringField(Instance instance, String string, Heap heap) {
        Object object = instance.getValueOfField(string);
        if (object instanceof Instance && String.class.getName().equals(((Instance)object).getJavaClass().getName())) {
            return DetailsUtils.getInstanceString((Instance)object, heap);
        }
        return null;
    }

    private static class ComponentTopComponent
    extends ProfilerTopComponent {
        private static final String HELP_CTX_KEY = "HeapWalker.ComponentPreview.HelpCtx";
        private static final HelpCtx HELP_CTX = new HelpCtx("HeapWalker.ComponentPreview.HelpCtx");

        ComponentTopComponent(Component component, String string, int n) {
            this.setName(BrowserUtils.getSimpleType(string) + " #" + n);
            this.setToolTipText("Preview of " + string + " #" + n);
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(component), "Center");
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }
    }

    private static class ComponentView
    extends Utils.View<ComponentBuilders.ComponentBuilder> {
        private ComponentBuilders.ComponentBuilder builder;
        private Component component;
        private Component hover;
        private final MouseHandler mouse;
        private JComponent glassPane;
        private final String className;
        private final int instanceNumber;
        private final boolean enableNewWindow;
        private final boolean enableInteraction;

        ComponentView(Instance instance, Heap heap) {
            this(instance, heap, null, true, false);
        }

        private ComponentView(Instance instance, Heap heap, ComponentBuilders.ComponentBuilder componentBuilder, boolean bl, boolean bl2) {
            super(instance, heap);
            this.builder = componentBuilder;
            this.enableNewWindow = bl;
            this.enableInteraction = bl2;
            if (bl || bl2) {
                this.mouse = new MouseHandler();
                this.addMouseListener(this.mouse);
            } else {
                this.mouse = null;
            }
            if (bl) {
                this.className = instance.getJavaClass().getName();
                this.instanceNumber = instance.getInstanceNumber();
            } else {
                this.className = null;
                this.instanceNumber = -1;
            }
        }

        @Override
        protected ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
            if (this.builder == null) {
                this.builder = ComponentBuilders.getBuilder(instance, heap);
            }
            return this.builder;
        }

        @Override
        protected Component getComponent(ComponentBuilders.ComponentBuilder componentBuilder) {
            this.component = componentBuilder.createPresenter();
            if (this.component != null) {
                this.component.setVisible(true);
            }
            return this.component;
        }

        @Override
        protected void setupGlassPane(JPanel jPanel) {
            this.glassPane = jPanel;
            if (this.mouse != null) {
                jPanel.addMouseListener(this.mouse);
                if (this.enableInteraction) {
                    jPanel.addMouseMotionListener(this.mouse);
                }
            }
        }

        private void hoverChanged() {
            String string;
            if (this.hover != null) {
                JComponent jComponent = this.hover instanceof JComponent ? (JComponent)this.hover : null;
                Object object = jComponent == null ? null : jComponent.getClientProperty("className");
                String string2 = object == null ? "" : object.toString();
                string = string2.isEmpty() ? null : string2;
            } else {
                string = null;
            }
            if (string == null) {
                ToolTipManager.sharedInstance().mousePressed(null);
            }
            this.glassPane.setToolTipText(string);
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.hover != null) {
                Rectangle rectangle = SwingUtilities.convertRectangle(this.hover.getParent(), this.hover.getBounds(), this);
                graphics.setColor(Color.RED);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        static Component componentAt(Component component, int n, int n2) {
            if (!component.contains(n, n2)) {
                return null;
            }
            if (component instanceof Container) {
                for (Component component2 : ((Container)component).getComponents()) {
                    Component component3;
                    if (component2 == null || !component2.isVisible() || (component3 = ComponentView.componentAt(component2, n - component2.getX(), n2 - component2.getY())) == null) continue;
                    return component3;
                }
            }
            return component;
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (!this.enableNewWindow || this.builder == null || this.component == null) {
                return;
            }
            JMenuItem jMenuItem = new JMenuItem(Bundle.ComponentDetailsProvider_NewWindow()){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ComponentView.this.openNewWindow();
                }
            };
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private void openNewWindow() {
            ComponentView componentView = new ComponentView(null, null, this.builder, false, true);
            ComponentTopComponent componentTopComponent = new ComponentTopComponent(componentView, this.className, this.instanceNumber);
            componentTopComponent.open();
            componentTopComponent.requestActive();
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ComponentView.this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ComponentView.this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Component component;
                Component component2 = component = mouseEvent == null ? null : ComponentView.componentAt(ComponentView.this.component, mouseEvent.getX(), mouseEvent.getY());
                if (ComponentView.this.hover == component) {
                    return;
                }
                ComponentView.this.hover = component;
                ComponentView.this.hoverChanged();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!ComponentView.this.enableInteraction) {
                    return;
                }
                this.mouseMoved(null);
            }
        }
    }
}

