/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

public final class Controller
implements MouseListener {
    private List<ActionListener> actionListenerList;
    private final SingleSelectionModel selectionModel = new DefaultSingleSelectionModel();
    private final TabDataModel tabModel;
    private final TabDisplayer displayer;

    public Controller(final TabDisplayer tabDisplayer) {
        this.displayer = tabDisplayer;
        this.tabModel = tabDisplayer.getModel();
        tabDisplayer.attach(this);
        this.selectionModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                tabDisplayer.setSelectedIndex(Controller.this.getSelectedIndex());
            }
        });
    }

    SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public TabDataModel getTabModel() {
        return this.tabModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActionListener(ActionListener actionListener) {
        Controller controller = this;
        synchronized (controller) {
            if (this.actionListenerList == null) {
                this.actionListenerList = new ArrayList<ActionListener>(5);
            }
            this.actionListenerList.add(actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActionListener(ActionListener actionListener) {
        Controller controller = this;
        synchronized (controller) {
            if (this.actionListenerList != null) {
                this.actionListenerList.remove(actionListener);
                if (this.actionListenerList.isEmpty()) {
                    this.actionListenerList = null;
                }
            }
        }
    }

    public void addSelectionChangeListener(ChangeListener changeListener) {
        this.selectionModel.addChangeListener(changeListener);
    }

    public void removeSelectionChangeListener(ChangeListener changeListener) {
        this.selectionModel.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postActionEvent(TabActionEvent tabActionEvent) {
        List<ActionListener> list;
        Controller controller = this;
        synchronized (controller) {
            if (this.actionListenerList == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListenerList);
        }
        for (ActionListener actionListener : list) {
            actionListener.actionPerformed((ActionEvent)tabActionEvent);
        }
    }

    public void setSelectedIndex(int n) {
        this.selectionModel.setSelectedIndex(n);
    }

    public int getSelectedIndex() {
        return this.selectionModel.getSelectedIndex();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, this.displayer);
        TabData tabData = this.displayer.getTabAt(point);
        if (null == tabData) {
            return;
        }
        int n = this.tabModel.indexOf(tabData);
        if (mouseEvent.getClickCount() > 1 && mouseEvent.getButton() == 1) {
            TabActionEvent tabActionEvent = new TabActionEvent((Object)this.displayer, "maximize", n);
            this.postActionEvent(tabActionEvent);
        } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 2) {
            TabActionEvent tabActionEvent = new TabActionEvent((Object)this.displayer, "close", n);
            this.postActionEvent(tabActionEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, this.displayer);
        TabData tabData = this.displayer.getTabAt(point);
        if (null == tabData) {
            return;
        }
        int n = this.tabModel.indexOf(tabData);
        TabActionEvent tabActionEvent = new TabActionEvent((Object)this, "popup", n, mouseEvent);
        this.postActionEvent(tabActionEvent);
    }
}

