/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public class GlobalVisibilityQueryImpl
implements VisibilityQueryImplementation2 {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final String PROP_IGNORED_FILES = "IgnoredFiles";
    private Pattern ignoreFilesPattern = null;

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/core");
    }

    public boolean isVisible(FileObject fileObject) {
        return this.isVisible(fileObject.getNameExt());
    }

    public boolean isVisible(File file) {
        return this.isVisible(file.getName());
    }

    boolean isVisible(String string) {
        Pattern pattern = this.getIgnoreFilesPattern();
        return pattern != null ? !pattern.matcher(string).find() : true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    private Pattern getIgnoreFilesPattern() {
        if (this.ignoreFilesPattern == null) {
            String string = this.getIgnoredFiles();
            this.ignoreFilesPattern = string != null && string.length() > 0 ? Pattern.compile(string) : null;
        }
        return this.ignoreFilesPattern;
    }

    protected String getIgnoredFiles() {
        String string = GlobalVisibilityQueryImpl.getPreferences().get(PROP_IGNORED_FILES, "^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|_svn)$|~$|^\\.(?!(htaccess|git.+|hgignore)$).*$");
        GlobalVisibilityQueryImpl.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if (GlobalVisibilityQueryImpl.PROP_IGNORED_FILES.equals(preferenceChangeEvent.getKey())) {
                    GlobalVisibilityQueryImpl.this.ignoreFilesPattern = null;
                    GlobalVisibilityQueryImpl.this.cs.fireChange();
                }
            }
        });
        return string;
    }
}

