/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

class FolderComparator
extends DataFolder.SortMode {
    public static final int NONE = 0;
    public static final int NAMES = 1;
    public static final int CLASS = 2;
    public static final int FOLDER_NAMES = 3;
    public static final int LAST_MODIFIED = 4;
    public static final int SIZE = 5;
    public static final int EXTENSIONS = 6;
    private int mode;

    public FolderComparator() {
        this(3);
    }

    public FolderComparator(int n) {
        this.mode = n;
    }

    @Override
    public int compare(DataObject dataObject, DataObject dataObject2) {
        return this.doCompare(dataObject, dataObject2);
    }

    int doCompare(Object object, Object object2) {
        switch (this.mode) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.compareNames(object, object2);
            }
            case 2: {
                return this.compareClass(object, object2);
            }
            case 3: {
                return this.compareFoldersFirst(object, object2);
            }
            case 4: {
                return FolderComparator.compareLastModified(object, object2);
            }
            case 5: {
                return FolderComparator.compareSize(object, object2);
            }
            case 6: {
                return this.compareExtensions(object, object2);
            }
        }
        assert (false) : this.mode;
        return 0;
    }

    static FileObject findFileObject(Object object) {
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile();
        }
        Node node = (Node)object;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject.getPrimaryFile();
    }

    private static DataObject findDataObject(Object object) {
        if (object instanceof DataObject) {
            return (DataObject)object;
        }
        if (object instanceof FileObject) {
            try {
                return DataObject.find((FileObject)object);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }
        Node node = (Node)object;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject;
    }

    private int compareNames(Object object, Object object2) {
        return FolderComparator.findFileObject(object).getNameExt().compareTo(FolderComparator.findFileObject(object2).getNameExt());
    }

    private int compareFoldersFirst(Object object, Object object2) {
        boolean bl;
        boolean bl2 = FolderComparator.findFileObject(object).isFolder();
        if (bl2 != (bl = FolderComparator.findFileObject(object2).isFolder())) {
            return bl2 ? -1 : 1;
        }
        return this.compareNames(object, object2);
    }

    private int compareExtensions(Object object, Object object2) {
        String string;
        boolean bl;
        FileObject fileObject = FolderComparator.findFileObject(object);
        FileObject fileObject2 = FolderComparator.findFileObject(object2);
        boolean bl2 = fileObject.isFolder();
        if (bl2 != (bl = fileObject2.isFolder())) {
            return bl2 ? -1 : 1;
        }
        if (bl2) {
            return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
        }
        String string2 = fileObject.getExt();
        if (string2.equals(string = fileObject2.getExt())) {
            return fileObject.getName().compareTo(fileObject2.getName());
        }
        return string2.compareTo(string);
    }

    private int compareClass(Object object, Object object2) {
        Class<?> clazz;
        DataObject dataObject = FolderComparator.findDataObject(object);
        DataObject dataObject2 = FolderComparator.findDataObject(object2);
        Class<?> clazz2 = dataObject.getClass();
        if (clazz2 == (clazz = dataObject2.getClass())) {
            return this.compareNames(dataObject, dataObject2);
        }
        DataLoaderPool dataLoaderPool = DataLoaderPool.getDefault();
        Enumeration<DataLoader> enumeration = dataLoaderPool.allLoaders();
        while (enumeration.hasMoreElements()) {
            Class<? extends DataObject> clazz3 = enumeration.nextElement().getRepresentationClass();
            if (clazz3 == DataObject.class) continue;
            boolean bl = clazz3.isAssignableFrom(clazz2);
            boolean bl2 = clazz3.isAssignableFrom(clazz);
            if (bl && bl2) {
                return this.compareNames(dataObject, dataObject2);
            }
            if (bl) {
                return -1;
            }
            if (!bl2) continue;
            return 1;
        }
        return this.compareNames(dataObject, dataObject2);
    }

    private static int compareLastModified(Object object, Object object2) {
        Date date;
        boolean bl;
        boolean bl2 = FolderComparator.findFileObject(object).isFolder();
        if (bl2 != (bl = FolderComparator.findFileObject(object2).isFolder())) {
            return bl2 ? -1 : 1;
        }
        FileObject fileObject = FolderComparator.findFileObject(object);
        FileObject fileObject2 = FolderComparator.findFileObject(object2);
        Date date2 = fileObject.lastModified();
        if (date2.after(date = fileObject2.lastModified())) {
            return -1;
        }
        if (date.after(date2)) {
            return 1;
        }
        return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
    }

    private static int compareSize(Object object, Object object2) {
        long l;
        boolean bl;
        boolean bl2 = FolderComparator.findFileObject(object).isFolder();
        if (bl2 != (bl = FolderComparator.findFileObject(object2).isFolder())) {
            return bl2 ? -1 : 1;
        }
        FileObject fileObject = FolderComparator.findFileObject(object);
        FileObject fileObject2 = FolderComparator.findFileObject(object2);
        long l2 = fileObject.getSize();
        if (l2 > (l = fileObject2.getSize())) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
    }
}

