/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MapperQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.joda.time.DateTimeZone;

public class QueryStringQueryBuilder
extends AbstractQueryBuilder<QueryStringQueryBuilder> {
    public static final String NAME = "query_string";
    public static final boolean DEFAULT_AUTO_GENERATE_PHRASE_QUERIES = false;
    public static final int DEFAULT_MAX_DETERMINED_STATES = 10000;
    public static final boolean DEFAULT_LOWERCASE_EXPANDED_TERMS = true;
    public static final boolean DEFAULT_ENABLE_POSITION_INCREMENTS = true;
    public static final boolean DEFAULT_ESCAPE = false;
    public static final boolean DEFAULT_USE_DIS_MAX = true;
    public static final int DEFAULT_FUZZY_PREFIX_LENGTH = 0;
    public static final int DEFAULT_FUZZY_MAX_EXPANSIONS = 50;
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final float DEFAULT_TIE_BREAKER = 0.0f;
    public static final Fuzziness DEFAULT_FUZZINESS = Fuzziness.AUTO;
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    public static final Locale DEFAULT_LOCALE = Locale.ROOT;
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField DEFAULT_FIELD_FIELD = new ParseField("default_field", new String[0]);
    private static final ParseField DEFAULT_OPERATOR_FIELD = new ParseField("default_operator", new String[0]);
    private static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static final ParseField QUOTE_ANALYZER_FIELD = new ParseField("quote_analyzer", new String[0]);
    private static final ParseField ALLOW_LEADING_WILDCARD_FIELD = new ParseField("allow_leading_wildcard", new String[0]);
    private static final ParseField AUTO_GENERATE_PHRASE_QUERIES_FIELD = new ParseField("auto_generate_phrase_queries", new String[0]);
    private static final ParseField MAX_DETERMINED_STATES_FIELD = new ParseField("max_determined_states", new String[0]);
    private static final ParseField LOWERCASE_EXPANDED_TERMS_FIELD = new ParseField("lowercase_expanded_terms", new String[0]);
    private static final ParseField ENABLE_POSITION_INCREMENTS_FIELD = new ParseField("enable_position_increment", new String[0]);
    private static final ParseField ESCAPE_FIELD = new ParseField("escape", new String[0]);
    private static final ParseField USE_DIS_MAX_FIELD = new ParseField("use_dis_max", new String[0]);
    private static final ParseField FUZZY_PREFIX_LENGTH_FIELD = new ParseField("fuzzy_prefix_length", new String[0]);
    private static final ParseField FUZZY_MAX_EXPANSIONS_FIELD = new ParseField("fuzzy_max_expansions", new String[0]);
    private static final ParseField FUZZY_REWRITE_FIELD = new ParseField("fuzzy_rewrite", new String[0]);
    private static final ParseField PHRASE_SLOP_FIELD = new ParseField("phrase_slop", new String[0]);
    private static final ParseField TIE_BREAKER_FIELD = new ParseField("tie_breaker", new String[0]);
    private static final ParseField ANALYZE_WILDCARD_FIELD = new ParseField("analyze_wildcard", new String[0]);
    private static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField QUOTE_FIELD_SUFFIX_FIELD = new ParseField("quote_field_suffix", new String[0]);
    private static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    private static final ParseField LOCALE_FIELD = new ParseField("locale", new String[0]);
    private static final ParseField TIME_ZONE_FIELD = new ParseField("time_zone", new String[0]);
    private final String queryString;
    private String defaultField;
    private final Map<String, Float> fieldsAndWeights = new TreeMap<String, Float>();
    private Operator defaultOperator = DEFAULT_OPERATOR;
    private String analyzer;
    private String quoteAnalyzer;
    private String quoteFieldSuffix;
    private boolean autoGeneratePhraseQueries = false;
    private Boolean allowLeadingWildcard;
    private Boolean analyzeWildcard;
    private boolean lowercaseExpandedTerms = true;
    private boolean enablePositionIncrements = true;
    private Locale locale = DEFAULT_LOCALE;
    private Fuzziness fuzziness = DEFAULT_FUZZINESS;
    private int fuzzyPrefixLength = 0;
    private int fuzzyMaxExpansions = 50;
    private String rewrite;
    private String fuzzyRewrite;
    private boolean escape = false;
    private int phraseSlop = 0;
    private boolean useDisMax = true;
    private float tieBreaker = 0.0f;
    private String minimumShouldMatch;
    private Boolean lenient;
    private DateTimeZone timeZone;
    private int maxDeterminizedStates = 10000;

    public QueryStringQueryBuilder(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("query text missing");
        }
        this.queryString = queryString;
    }

    public QueryStringQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryString = in.readString();
        this.defaultField = in.readOptionalString();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.fieldsAndWeights.put(in.readString(), Float.valueOf(in.readFloat()));
        }
        this.defaultOperator = Operator.readFromStream(in);
        this.analyzer = in.readOptionalString();
        this.quoteAnalyzer = in.readOptionalString();
        this.quoteFieldSuffix = in.readOptionalString();
        this.autoGeneratePhraseQueries = in.readBoolean();
        this.allowLeadingWildcard = in.readOptionalBoolean();
        this.analyzeWildcard = in.readOptionalBoolean();
        this.lowercaseExpandedTerms = in.readBoolean();
        this.enablePositionIncrements = in.readBoolean();
        this.locale = Locale.forLanguageTag(in.readString());
        this.fuzziness = new Fuzziness(in);
        this.fuzzyPrefixLength = in.readVInt();
        this.fuzzyMaxExpansions = in.readVInt();
        this.fuzzyRewrite = in.readOptionalString();
        this.phraseSlop = in.readVInt();
        this.useDisMax = in.readBoolean();
        this.tieBreaker = in.readFloat();
        this.rewrite = in.readOptionalString();
        this.minimumShouldMatch = in.readOptionalString();
        this.lenient = in.readOptionalBoolean();
        this.timeZone = in.readOptionalTimeZone();
        this.escape = in.readBoolean();
        this.maxDeterminizedStates = in.readVInt();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.queryString);
        out.writeOptionalString(this.defaultField);
        out.writeVInt(this.fieldsAndWeights.size());
        for (Map.Entry<String, Float> fieldsEntry : this.fieldsAndWeights.entrySet()) {
            out.writeString(fieldsEntry.getKey());
            out.writeFloat(fieldsEntry.getValue().floatValue());
        }
        this.defaultOperator.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.quoteAnalyzer);
        out.writeOptionalString(this.quoteFieldSuffix);
        out.writeBoolean(this.autoGeneratePhraseQueries);
        out.writeOptionalBoolean(this.allowLeadingWildcard);
        out.writeOptionalBoolean(this.analyzeWildcard);
        out.writeBoolean(this.lowercaseExpandedTerms);
        out.writeBoolean(this.enablePositionIncrements);
        out.writeString(this.locale.toLanguageTag());
        this.fuzziness.writeTo(out);
        out.writeVInt(this.fuzzyPrefixLength);
        out.writeVInt(this.fuzzyMaxExpansions);
        out.writeOptionalString(this.fuzzyRewrite);
        out.writeVInt(this.phraseSlop);
        out.writeBoolean(this.useDisMax);
        out.writeFloat(this.tieBreaker);
        out.writeOptionalString(this.rewrite);
        out.writeOptionalString(this.minimumShouldMatch);
        out.writeOptionalBoolean(this.lenient);
        out.writeOptionalTimeZone(this.timeZone);
        out.writeBoolean(this.escape);
        out.writeVInt(this.maxDeterminizedStates);
    }

    public String queryString() {
        return this.queryString;
    }

    public QueryStringQueryBuilder defaultField(String defaultField) {
        this.defaultField = defaultField;
        return this;
    }

    public String defaultField() {
        return this.defaultField;
    }

    public QueryStringQueryBuilder field(String field) {
        this.fieldsAndWeights.put(field, Float.valueOf(1.0f));
        return this;
    }

    public QueryStringQueryBuilder field(String field, float boost) {
        this.fieldsAndWeights.put(field, Float.valueOf(boost));
        return this;
    }

    public QueryStringQueryBuilder fields(Map<String, Float> fields) {
        this.fieldsAndWeights.putAll(fields);
        return this;
    }

    public Map<String, Float> fields() {
        return this.fieldsAndWeights;
    }

    public QueryStringQueryBuilder useDisMax(boolean useDisMax) {
        this.useDisMax = useDisMax;
        return this;
    }

    public boolean useDisMax() {
        return this.useDisMax;
    }

    public QueryStringQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    public QueryStringQueryBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator == null ? DEFAULT_OPERATOR : defaultOperator;
        return this;
    }

    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    public QueryStringQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public QueryStringQueryBuilder quoteAnalyzer(String quoteAnalyzer) {
        this.quoteAnalyzer = quoteAnalyzer;
        return this;
    }

    public QueryStringQueryBuilder autoGeneratePhraseQueries(boolean autoGeneratePhraseQueries) {
        this.autoGeneratePhraseQueries = autoGeneratePhraseQueries;
        return this;
    }

    public boolean autoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public QueryStringQueryBuilder maxDeterminizedStates(int maxDeterminizedStates) {
        this.maxDeterminizedStates = maxDeterminizedStates;
        return this;
    }

    public int maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    public QueryStringQueryBuilder allowLeadingWildcard(Boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        return this;
    }

    public Boolean allowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public QueryStringQueryBuilder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        return this;
    }

    public boolean lowercaseExpandedTerms() {
        return this.lowercaseExpandedTerms;
    }

    public QueryStringQueryBuilder enablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
        return this;
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public QueryStringQueryBuilder fuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness == null ? DEFAULT_FUZZINESS : fuzziness;
        return this;
    }

    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    public QueryStringQueryBuilder fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
        return this;
    }

    public int fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public QueryStringQueryBuilder fuzzyMaxExpansions(int fuzzyMaxExpansions) {
        this.fuzzyMaxExpansions = fuzzyMaxExpansions;
        return this;
    }

    public int fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    public QueryStringQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    public QueryStringQueryBuilder phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
        return this;
    }

    public int phraseSlop() {
        return this.phraseSlop;
    }

    public QueryStringQueryBuilder analyzeWildcard(Boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
        return this;
    }

    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    public QueryStringQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public String rewrite() {
        return this.rewrite;
    }

    public QueryStringQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public QueryStringQueryBuilder quoteFieldSuffix(String quoteFieldSuffix) {
        this.quoteFieldSuffix = quoteFieldSuffix;
        return this;
    }

    public String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    public QueryStringQueryBuilder lenient(Boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public Boolean lenient() {
        return this.lenient;
    }

    public QueryStringQueryBuilder locale(Locale locale) {
        this.locale = locale == null ? DEFAULT_LOCALE : locale;
        return this;
    }

    public Locale locale() {
        return this.locale;
    }

    public QueryStringQueryBuilder timeZone(String timeZone) {
        this.timeZone = timeZone != null ? DateTimeZone.forID((String)timeZone) : null;
        return this;
    }

    public QueryStringQueryBuilder timeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public DateTimeZone timeZone() {
        return this.timeZone;
    }

    public QueryStringQueryBuilder escape(boolean escape) {
        this.escape = escape;
        return this;
    }

    public boolean escape() {
        return this.escape;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.queryString);
        if (this.defaultField != null) {
            builder.field(DEFAULT_FIELD_FIELD.getPreferredName(), this.defaultField);
        }
        builder.startArray(FIELDS_FIELD.getPreferredName());
        for (Map.Entry<String, Float> fieldEntry : this.fieldsAndWeights.entrySet()) {
            builder.value(fieldEntry.getKey() + "^" + fieldEntry.getValue());
        }
        builder.endArray();
        builder.field(USE_DIS_MAX_FIELD.getPreferredName(), this.useDisMax);
        builder.field(TIE_BREAKER_FIELD.getPreferredName(), this.tieBreaker);
        builder.field(DEFAULT_OPERATOR_FIELD.getPreferredName(), this.defaultOperator.name().toLowerCase(Locale.ROOT));
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        if (this.quoteAnalyzer != null) {
            builder.field(QUOTE_ANALYZER_FIELD.getPreferredName(), this.quoteAnalyzer);
        }
        builder.field(AUTO_GENERATE_PHRASE_QUERIES_FIELD.getPreferredName(), this.autoGeneratePhraseQueries);
        builder.field(MAX_DETERMINED_STATES_FIELD.getPreferredName(), this.maxDeterminizedStates);
        if (this.allowLeadingWildcard != null) {
            builder.field(ALLOW_LEADING_WILDCARD_FIELD.getPreferredName(), this.allowLeadingWildcard);
        }
        builder.field(LOWERCASE_EXPANDED_TERMS_FIELD.getPreferredName(), this.lowercaseExpandedTerms);
        builder.field(ENABLE_POSITION_INCREMENTS_FIELD.getPreferredName(), this.enablePositionIncrements);
        this.fuzziness.toXContent(builder, params);
        builder.field(FUZZY_PREFIX_LENGTH_FIELD.getPreferredName(), this.fuzzyPrefixLength);
        builder.field(FUZZY_MAX_EXPANSIONS_FIELD.getPreferredName(), this.fuzzyMaxExpansions);
        if (this.fuzzyRewrite != null) {
            builder.field(FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite);
        }
        builder.field(PHRASE_SLOP_FIELD.getPreferredName(), this.phraseSlop);
        if (this.analyzeWildcard != null) {
            builder.field(ANALYZE_WILDCARD_FIELD.getPreferredName(), this.analyzeWildcard);
        }
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.quoteFieldSuffix != null) {
            builder.field(QUOTE_FIELD_SUFFIX_FIELD.getPreferredName(), this.quoteFieldSuffix);
        }
        if (this.lenient != null) {
            builder.field(LENIENT_FIELD.getPreferredName(), this.lenient);
        }
        builder.field(LOCALE_FIELD.getPreferredName(), this.locale.toLanguageTag());
        if (this.timeZone != null) {
            builder.field(TIME_ZONE_FIELD.getPreferredName(), this.timeZone.getID());
        }
        builder.field(ESCAPE_FIELD.getPreferredName(), this.escape);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<QueryStringQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String currentFieldName = null;
        String queryString = null;
        String defaultField = null;
        String analyzer = null;
        String quoteAnalyzer = null;
        String queryName = null;
        float boost = 1.0f;
        boolean autoGeneratePhraseQueries = false;
        int maxDeterminizedStates = 10000;
        boolean lowercaseExpandedTerms = true;
        boolean enablePositionIncrements = true;
        boolean escape = false;
        boolean useDisMax = true;
        int fuzzyPrefixLength = 0;
        int fuzzyMaxExpansions = 50;
        int phraseSlop = 0;
        float tieBreaker = 0.0f;
        Boolean analyzeWildcard = null;
        Boolean allowLeadingWildcard = null;
        String minimumShouldMatch = null;
        String quoteFieldSuffix = null;
        Boolean lenient = null;
        Operator defaultOperator = DEFAULT_OPERATOR;
        String timeZone = null;
        Locale locale = DEFAULT_LOCALE;
        Fuzziness fuzziness = DEFAULT_FUZZINESS;
        String fuzzyRewrite = null;
        String rewrite = null;
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, FIELDS_FIELD)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String fField = null;
                        float fBoost = 1.0f;
                        char[] text = parser.textCharacters();
                        int end = parser.textOffset() + parser.textLength();
                        for (int i = parser.textOffset(); i < end; ++i) {
                            if (text[i] != '^') continue;
                            int relativeLocation = i - parser.textOffset();
                            fField = new String(text, parser.textOffset(), relativeLocation);
                            fBoost = Float.parseFloat(new String(text, i + 1, parser.textLength() - relativeLocation - 1));
                            break;
                        }
                        if (fField == null) {
                            fField = parser.text();
                        }
                        fieldsAndWeights.put(fField, Float.valueOf(fBoost));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                    queryString = parser.text();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, DEFAULT_FIELD_FIELD)) {
                    defaultField = parser.text();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, DEFAULT_OPERATOR_FIELD)) {
                    defaultOperator = Operator.fromString(parser.text());
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, ANALYZER_FIELD)) {
                    analyzer = parser.text();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, QUOTE_ANALYZER_FIELD)) {
                    quoteAnalyzer = parser.text();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, ALLOW_LEADING_WILDCARD_FIELD)) {
                    allowLeadingWildcard = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AUTO_GENERATE_PHRASE_QUERIES_FIELD)) {
                    autoGeneratePhraseQueries = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, MAX_DETERMINED_STATES_FIELD)) {
                    maxDeterminizedStates = parser.intValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, LOWERCASE_EXPANDED_TERMS_FIELD)) {
                    lowercaseExpandedTerms = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, ENABLE_POSITION_INCREMENTS_FIELD)) {
                    enablePositionIncrements = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, ESCAPE_FIELD)) {
                    escape = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, USE_DIS_MAX_FIELD)) {
                    useDisMax = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, FUZZY_PREFIX_LENGTH_FIELD)) {
                    fuzzyPrefixLength = parser.intValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, FUZZY_MAX_EXPANSIONS_FIELD)) {
                    fuzzyMaxExpansions = parser.intValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, FUZZY_REWRITE_FIELD)) {
                    fuzzyRewrite = parser.textOrNull();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, PHRASE_SLOP_FIELD)) {
                    phraseSlop = parser.intValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, Fuzziness.FIELD)) {
                    fuzziness = Fuzziness.parse(parser);
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, TIE_BREAKER_FIELD)) {
                    tieBreaker = parser.floatValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, ANALYZE_WILDCARD_FIELD)) {
                    analyzeWildcard = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, REWRITE_FIELD)) {
                    rewrite = parser.textOrNull();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, MINIMUM_SHOULD_MATCH_FIELD)) {
                    minimumShouldMatch = parser.textOrNull();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, QUOTE_FIELD_SUFFIX_FIELD)) {
                    quoteFieldSuffix = parser.textOrNull();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, LENIENT_FIELD)) {
                    lenient = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, LOCALE_FIELD)) {
                    String localeStr = parser.text();
                    locale = Locale.forLanguageTag(localeStr);
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, TIME_ZONE_FIELD)) {
                    try {
                        timeZone = parser.text();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParsingException(parser.getTokenLocation(), "[query_string] time_zone [" + parser.text() + "] is unknown", new Object[0]);
                    }
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[query_string] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (queryString == null) {
            throw new ParsingException(parser.getTokenLocation(), "[query_string] must be provided with a [query]", new Object[0]);
        }
        QueryStringQueryBuilder queryStringQuery = new QueryStringQueryBuilder(queryString);
        queryStringQuery.fields(fieldsAndWeights);
        queryStringQuery.defaultField(defaultField);
        queryStringQuery.defaultOperator(defaultOperator);
        queryStringQuery.analyzer(analyzer);
        queryStringQuery.quoteAnalyzer(quoteAnalyzer);
        queryStringQuery.allowLeadingWildcard(allowLeadingWildcard);
        queryStringQuery.autoGeneratePhraseQueries(autoGeneratePhraseQueries);
        queryStringQuery.maxDeterminizedStates(maxDeterminizedStates);
        queryStringQuery.lowercaseExpandedTerms(lowercaseExpandedTerms);
        queryStringQuery.enablePositionIncrements(enablePositionIncrements);
        queryStringQuery.escape(escape);
        queryStringQuery.useDisMax(useDisMax);
        queryStringQuery.fuzzyPrefixLength(fuzzyPrefixLength);
        queryStringQuery.fuzzyMaxExpansions(fuzzyMaxExpansions);
        queryStringQuery.fuzzyRewrite(fuzzyRewrite);
        queryStringQuery.phraseSlop(phraseSlop);
        queryStringQuery.fuzziness(fuzziness);
        queryStringQuery.tieBreaker(tieBreaker);
        queryStringQuery.analyzeWildcard(analyzeWildcard);
        queryStringQuery.rewrite(rewrite);
        queryStringQuery.minimumShouldMatch(minimumShouldMatch);
        queryStringQuery.quoteFieldSuffix(quoteFieldSuffix);
        queryStringQuery.lenient(lenient);
        queryStringQuery.timeZone(timeZone);
        queryStringQuery.locale(locale);
        queryStringQuery.boost(boost);
        queryStringQuery.queryName(queryName);
        return Optional.of(queryStringQuery);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(QueryStringQueryBuilder other) {
        return Objects.equals(this.queryString, other.queryString) && Objects.equals(this.defaultField, other.defaultField) && Objects.equals(this.fieldsAndWeights, other.fieldsAndWeights) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.quoteAnalyzer, other.quoteAnalyzer) && Objects.equals(this.quoteFieldSuffix, other.quoteFieldSuffix) && Objects.equals(this.autoGeneratePhraseQueries, other.autoGeneratePhraseQueries) && Objects.equals(this.allowLeadingWildcard, other.allowLeadingWildcard) && Objects.equals(this.lowercaseExpandedTerms, other.lowercaseExpandedTerms) && Objects.equals(this.enablePositionIncrements, other.enablePositionIncrements) && Objects.equals(this.analyzeWildcard, other.analyzeWildcard) && Objects.equals(this.locale.toLanguageTag(), other.locale.toLanguageTag()) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.fuzzyPrefixLength, other.fuzzyPrefixLength) && Objects.equals(this.fuzzyMaxExpansions, other.fuzzyMaxExpansions) && Objects.equals(this.fuzzyRewrite, other.fuzzyRewrite) && Objects.equals(this.phraseSlop, other.phraseSlop) && Objects.equals(this.useDisMax, other.useDisMax) && Objects.equals(Float.valueOf(this.tieBreaker), Float.valueOf(other.tieBreaker)) && Objects.equals(this.rewrite, other.rewrite) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.lenient, other.lenient) && this.timeZone == null ? other.timeZone == null : other.timeZone != null && Objects.equals(this.timeZone.getID(), other.timeZone.getID()) && Objects.equals(this.escape, other.escape) && Objects.equals(this.maxDeterminizedStates, other.maxDeterminizedStates);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.queryString, this.defaultField, this.fieldsAndWeights, this.defaultOperator, this.analyzer, this.quoteAnalyzer, this.quoteFieldSuffix, this.autoGeneratePhraseQueries, this.allowLeadingWildcard, this.lowercaseExpandedTerms, this.enablePositionIncrements, this.analyzeWildcard, this.locale.toLanguageTag(), this.fuzziness, this.fuzzyPrefixLength, this.fuzzyMaxExpansions, this.fuzzyRewrite, this.phraseSlop, this.useDisMax, Float.valueOf(this.tieBreaker), this.rewrite, this.minimumShouldMatch, this.lenient, this.timeZone == null ? Integer.valueOf(0) : this.timeZone.getID(), this.escape, this.maxDeterminizedStates);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query query;
        NamedAnalyzer namedAnalyzer;
        QueryParserSettings qpSettings = this.escape ? new QueryParserSettings(QueryParser.escape((String)this.queryString)) : new QueryParserSettings(this.queryString);
        qpSettings.defaultField(this.defaultField == null ? context.defaultField() : this.defaultField);
        TreeMap<String, Float> resolvedFields = new TreeMap<String, Float>();
        for (Map.Entry<String, Float> fieldsEntry : this.fieldsAndWeights.entrySet()) {
            String fieldName = fieldsEntry.getKey();
            Float weight = fieldsEntry.getValue();
            if (Regex.isSimpleMatchPattern(fieldName)) {
                for (String resolvedFieldName : context.getMapperService().simpleMatchToIndexNames(fieldName)) {
                    resolvedFields.put(resolvedFieldName, weight);
                }
                continue;
            }
            resolvedFields.put(fieldName, weight);
        }
        qpSettings.fieldsAndWeights(resolvedFields);
        qpSettings.defaultOperator(this.defaultOperator.toQueryParserOperator());
        if (this.analyzer == null) {
            qpSettings.defaultAnalyzer(context.getMapperService().searchAnalyzer());
        } else {
            namedAnalyzer = context.getAnalysisService().analyzer(this.analyzer);
            if (namedAnalyzer == null) {
                throw new QueryShardException(context, "[query_string] analyzer [" + this.analyzer + "] not found", new Object[0]);
            }
            qpSettings.forceAnalyzer((Analyzer)namedAnalyzer);
        }
        if (this.quoteAnalyzer != null) {
            namedAnalyzer = context.getAnalysisService().analyzer(this.quoteAnalyzer);
            if (namedAnalyzer == null) {
                throw new QueryShardException(context, "[query_string] quote_analyzer [" + this.quoteAnalyzer + "] not found", new Object[0]);
            }
            qpSettings.forceQuoteAnalyzer((Analyzer)namedAnalyzer);
        } else if (this.analyzer != null) {
            qpSettings.forceQuoteAnalyzer(qpSettings.analyzer());
        } else {
            qpSettings.defaultQuoteAnalyzer(context.getMapperService().searchQuoteAnalyzer());
        }
        qpSettings.quoteFieldSuffix(this.quoteFieldSuffix);
        qpSettings.autoGeneratePhraseQueries(this.autoGeneratePhraseQueries);
        qpSettings.allowLeadingWildcard(this.allowLeadingWildcard == null ? context.queryStringAllowLeadingWildcard() : this.allowLeadingWildcard.booleanValue());
        qpSettings.analyzeWildcard(this.analyzeWildcard == null ? context.queryStringAnalyzeWildcard() : this.analyzeWildcard.booleanValue());
        qpSettings.lowercaseExpandedTerms(this.lowercaseExpandedTerms);
        qpSettings.enablePositionIncrements(this.enablePositionIncrements);
        qpSettings.locale(this.locale);
        qpSettings.fuzziness(this.fuzziness);
        qpSettings.fuzzyPrefixLength(this.fuzzyPrefixLength);
        qpSettings.fuzzyMaxExpansions(this.fuzzyMaxExpansions);
        qpSettings.fuzzyRewriteMethod(QueryParsers.parseRewriteMethod(context.getParseFieldMatcher(), this.fuzzyRewrite));
        qpSettings.phraseSlop(this.phraseSlop);
        qpSettings.useDisMax(this.useDisMax);
        qpSettings.tieBreaker(this.tieBreaker);
        qpSettings.rewriteMethod(QueryParsers.parseRewriteMethod(context.getParseFieldMatcher(), this.rewrite));
        qpSettings.lenient(this.lenient == null ? context.queryStringLenient() : this.lenient.booleanValue());
        qpSettings.timeZone(this.timeZone);
        qpSettings.maxDeterminizedStates(this.maxDeterminizedStates);
        MapperQueryParser queryParser = context.queryParser(qpSettings);
        try {
            query = queryParser.parse(this.queryString);
        }
        catch (ParseException e) {
            throw new QueryShardException(context, "Failed to parse query [" + this.queryString + "]", e, new Object[0]);
        }
        if (query == null) {
            return null;
        }
        ArrayList<Float> boosts = new ArrayList<Float>();
        while (query instanceof BoostQuery) {
            BoostQuery boostQuery = (BoostQuery)query;
            boosts.add(Float.valueOf(boostQuery.getBoost()));
            query = boostQuery.getQuery();
        }
        if ((query = Queries.fixNegativeQueryIfNeeded(query)) instanceof BooleanQuery && !((BooleanQuery)query).isCoordDisabled()) {
            query = Queries.applyMinimumShouldMatch((BooleanQuery)query, this.minimumShouldMatch());
        }
        for (int i = boosts.size() - 1; i >= 0; --i) {
            query = new BoostQuery(query, ((Float)boosts.get(i)).floatValue());
        }
        return query;
    }
}

