/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.progress.ProgressLogger;

public class ResourceOperation {
    private final ProgressLogger progressLogger;
    private final Type operationType;
    private final String contentLengthString;
    private long loggedKBytes;
    private long totalProcessedBytes;

    public ResourceOperation(ProgressLogger progressLogger, Type type, long contentLength) {
        this.progressLogger = progressLogger;
        this.operationType = type;
        this.contentLengthString = this.getLengthText(contentLength != 0L ? Long.valueOf(contentLength) : null);
    }

    private String getLengthText(Long bytes) {
        if (bytes == null) {
            return "unknown size";
        }
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        return String.format("%.2f MB", (double)bytes.longValue() / 1048576.0);
    }

    public void logProcessedBytes(long processedBytes) {
        this.totalProcessedBytes += processedBytes;
        long processedKB = this.totalProcessedBytes / 1024L;
        if (processedKB > this.loggedKBytes) {
            this.loggedKBytes = processedKB;
            String progressMessage = String.format("%s/%s %sed", new Object[]{this.getLengthText(this.totalProcessedBytes), this.contentLengthString, this.operationType});
            this.progressLogger.progress(progressMessage);
        }
    }

    public void completed() {
        this.progressLogger.completed();
    }

    public static enum Type {
        download,
        upload;


        public String getCapitalized() {
            return StringUtils.capitalize((String)this.toString());
        }
    }
}

