/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.render.internal.html;

import groovy.lang.Closure;
import groovy.xml.MarkupBuilder;
import java.io.File;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Transformer;
import org.gradle.api.internal.ClosureBackedAction;

public class HtmlRenderContext {
    private final MarkupBuilder markupBuilder;
    private final Transformer<String, File> relativizer;

    public HtmlRenderContext(MarkupBuilder markupBuilder, Transformer<String, File> relativizer) {
        this.relativizer = relativizer;
        this.markupBuilder = markupBuilder;
    }

    public void render(Closure<?> renderAction) {
        ClosureBackedAction.execute((Object)this.markupBuilder, renderAction);
    }

    public String relativePath(File file) {
        return (String)this.relativizer.transform((Object)file);
    }

    public String getDiffClass() {
        return "diff";
    }

    public String getEqualClass() {
        return "equal";
    }

    public String getComparisonResultMsgClass() {
        return "comparison-result-msg";
    }

    public String diffClass(Object isEqual) {
        return this.groovyTrue(isEqual) ? "" : this.getDiffClass();
    }

    public String equalClass(Object isEqual) {
        return this.groovyTrue(isEqual) ? this.getEqualClass() : "";
    }

    public String equalOrDiffClass(Object isEqual) {
        return this.groovyTrue(isEqual) ? this.getEqualClass() : this.getDiffClass();
    }

    private boolean groovyTrue(Object equal) {
        return (Boolean)InvokerHelper.invokeMethod((Object)equal, (String)"asBoolean", null);
    }
}

