/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.initialization.IncludedBuildExecuter;
import org.gradle.initialization.IncludedBuilds;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultIncludedBuildExecuter
implements IncludedBuildExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncludedBuildExecuter.class);
    private final IncludedBuilds includedBuilds;
    private final Lock lock = new ReentrantLock();
    private final Condition buildCompleted = this.lock.newCondition();
    private final List<BuildRequest> executingBuilds = Lists.newLinkedList();
    private final Multimap<BuildIdentifier, String> executedTasks = LinkedHashMultimap.create();

    public DefaultIncludedBuildExecuter(IncludedBuilds includedBuilds) {
        this.includedBuilds = includedBuilds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(BuildIdentifier sourceBuild, BuildIdentifier targetBuild, Iterable<String> taskNames) {
        BuildRequest buildRequest = new BuildRequest(sourceBuild, targetBuild, taskNames);
        this.buildStarted(buildRequest);
        try {
            this.doBuild(targetBuild, taskNames);
        }
        finally {
            this.buildCompleted(buildRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStarted(BuildRequest buildRequest) {
        this.lock.lock();
        try {
            ArrayList candidateCycle = Lists.newArrayList();
            this.checkNoCycles(buildRequest, buildRequest.targetBuild, candidateCycle);
            this.waitForExistingBuildToComplete(buildRequest.targetBuild);
            this.executingBuilds.add(buildRequest);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkNoCycles(BuildRequest buildRequest, BuildIdentifier target, List<BuildIdentifier> candidateCycle) {
        candidateCycle.add(target);
        for (BuildRequest executingBuild : this.executingBuilds) {
            if (!executingBuild.requestingBuild.equals(target)) continue;
            BuildIdentifier nextTarget = executingBuild.targetBuild;
            if (nextTarget.equals(buildRequest.requestingBuild)) {
                candidateCycle.add(nextTarget);
                ProjectComponentSelector selector = DefaultProjectComponentSelector.newSelector((BuildIdentifier)buildRequest.targetBuild, (String)":");
                throw new ModuleVersionResolveException((ComponentSelector)selector, "Included build dependency cycle: " + this.reportCycle(candidateCycle));
            }
            this.checkNoCycles(buildRequest, nextTarget, candidateCycle);
        }
        candidateCycle.remove(target);
    }

    private void waitForExistingBuildToComplete(BuildIdentifier buildId) {
        try {
            while (this.buildInProgress(buildId)) {
                this.buildCompleted.await();
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private boolean buildInProgress(BuildIdentifier buildId) {
        for (BuildRequest executingBuild : this.executingBuilds) {
            if (!executingBuild.targetBuild.equals(buildId)) continue;
            return true;
        }
        return false;
    }

    private String reportCycle(List<BuildIdentifier> cycle) {
        StringBuilder cycleReport = new StringBuilder();
        for (BuildIdentifier buildIdentifier : cycle) {
            cycleReport.append(buildIdentifier);
            cycleReport.append(" -> ");
        }
        cycleReport.append(cycle.get(0));
        return cycleReport.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCompleted(BuildRequest buildRequest) {
        this.lock.lock();
        try {
            this.executingBuilds.remove(buildRequest);
            this.buildCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doBuild(BuildIdentifier buildId, Iterable<String> taskPaths) {
        ArrayList tasksToExecute = Lists.newArrayList();
        for (String taskPath : taskPaths) {
            if (!this.executedTasks.put((Object)buildId, (Object)taskPath)) continue;
            tasksToExecute.add(taskPath);
        }
        if (tasksToExecute.isEmpty()) {
            return;
        }
        LOGGER.info("Executing " + buildId.getName() + " tasks " + taskPaths);
        IncludedBuildInternal build = (IncludedBuildInternal)this.includedBuilds.getBuild(buildId.getName());
        build.execute(tasksToExecute);
    }

    private class BuildRequest {
        final BuildIdentifier requestingBuild;
        final BuildIdentifier targetBuild;
        final Iterable<String> tasks;

        public BuildRequest(BuildIdentifier requestingBuild, BuildIdentifier targetBuild, Iterable<String> tasks) {
            this.requestingBuild = requestingBuild;
            this.targetBuild = targetBuild;
            this.tasks = tasks;
        }
    }
}

