/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.PluginCliParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.com.google.common.base.Predicates;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.script.StandardScriptDefinition;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0014J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "createArguments", "createCoreEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "rootDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "Companion", "kotlin-compiler"})
public final class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    private static long initStartNanos;
    private static final HashMap<String, Long> elapsedGCTime;
    private static long elapsedJITTime;
    public static final Companion Companion;

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable) {
        List<Object> friendPaths;
        List<Object> list2;
        Object message;
        Intrinsics.checkParameterIsNotNull(arguments, "arguments");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(rootDisposable, "rootDisposable");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        KotlinPaths paths = arguments.kotlinHome != null ? (KotlinPaths)new KotlinPathsFromHomeDir(new File(arguments.kotlinHome)) : PathUtil.getKotlinPathsForCompiler();
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), CompilerMessageLocation.NO_LOCATION);
        PerformanceCounter.Companion.setTimeCounterEnabled(arguments.reportPerf);
        MessageCollector messageCollector2 = messageCollector;
        Intrinsics.checkExpressionValueIsNotNull(messageCollector2, "messageCollector");
        ExitCode exitCode = K2JVMCompiler.Companion.setupJdkClasspathRoots(arguments, configuration, messageCollector2);
        ExitCode it = exitCode;
        if (Intrinsics.areEqual((Object)it, (Object)ExitCode.OK) ^ true) {
            return it;
        }
        try {
            PluginCliParser.loadPlugins(arguments, configuration);
        }
        catch (PluginCliOptionProcessingException e) {
            message = e.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions());
            messageCollector.report(CompilerMessageSeverity.ERROR, (String)message, CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (CliOptionProcessingException e) {
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            messageCollector.report(CompilerMessageSeverity.ERROR, string, CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector, t);
            return ExitCode.INTERNAL_ERROR;
        }
        if (arguments.script) {
            if (arguments.freeArgs.isEmpty()) {
                messageCollector.report(CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", CompilerMessageLocation.NO_LOCATION);
                return ExitCode.COMPILATION_ERROR;
            }
            String string = (String)arguments.freeArgs.get(0);
            Intrinsics.checkExpressionValueIsNotNull(string, "arguments.freeArgs.get(0)");
            ContentRootsKt.addKotlinSourceRoot(configuration, string);
        } else if (arguments.module == null) {
            message = arguments.freeArgs.iterator();
            while (message.hasNext()) {
                String arg;
                String string = arg = (String)message.next();
                Intrinsics.checkExpressionValueIsNotNull(string, "arg");
                ContentRootsKt.addKotlinSourceRoot(configuration, string);
                File file2 = new File(arg);
                if (!file2.isDirectory()) continue;
                JvmContentRootsKt.addJavaSourceRoot$default(configuration, file2, null, 2, null);
            }
        }
        KotlinPaths kotlinPaths = paths;
        Intrinsics.checkExpressionValueIsNotNull(kotlinPaths, "paths");
        JvmContentRootsKt.addJvmClasspathRoots(configuration, K2JVMCompiler.Companion.getClasspath(kotlinPaths, arguments));
        String string = arguments.moduleName;
        if (string == null) {
            string = "main";
        }
        configuration.put(CommonConfigurationKeys.MODULE_NAME, string);
        if (arguments.module == null && arguments.freeArgs.isEmpty() && !arguments.version) {
            ReplFromTerminal.Companion.run(rootDisposable, configuration);
            return ExitCode.OK;
        }
        configuration.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, StandardScriptDefinition.INSTANCE);
        if (arguments.skipMetadataVersionCheck) {
            JvmMetadataVersion.Companion.setSkipCheck(true);
        }
        if (arguments.includeRuntime) {
            configuration.put(JVMConfigurationKeys.INCLUDE_RUNTIME, true);
        }
        if (arguments.friendPaths != null) {
            list2 = ArraysKt.toList((Object[])arguments.friendPaths);
        } else {
            String[] cfr_ignored_0 = arguments.friendPaths;
            list2 = friendPaths = null;
        }
        if (friendPaths != null) {
            configuration.put(JVMConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        if (arguments.jvmTarget != null) {
            String string2 = arguments.jvmTarget;
            Intrinsics.checkExpressionValueIsNotNull(string2, "arguments.jvmTarget");
            JvmTarget jvmTarget = JvmTarget.Companion.fromString(string2);
            if (jvmTarget != null) {
                configuration.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
            } else {
                String errorMessage2 = "Unknown JVM target version: " + arguments.jvmTarget + "\n" + ("Supported versions: " + ArraysKt.joinToString$default((Object[])JvmTarget.values(), null, null, null, 0, null, (Function1)doExecute.errorMessage.1.INSTANCE, 31, null));
                messageCollector.report(CompilerMessageSeverity.ERROR, errorMessage2, CompilerMessageLocation.NO_LOCATION);
            }
        }
        K2JVMCompiler.Companion.putAdvancedOptions(configuration, arguments);
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", CompilerMessageLocation.NO_LOCATION);
        try {
            String destination = arguments.destination;
            if (arguments.module != null) {
                FilteringMessageCollector sanitizedCollector = new FilteringMessageCollector(messageCollector, Predicates.in((Collection)CompilerMessageSeverity.VERBOSE));
                ModuleScriptData moduleScript = CompileEnvironmentUtil.loadModuleDescriptions(arguments.module, sanitizedCollector);
                if (destination != null) {
                    messageCollector.report(CompilerMessageSeverity.WARNING, "The '-d' option with a directory destination is ignored because '-module' is specified", CompilerMessageLocation.NO_LOCATION);
                }
                File moduleFile = new File(arguments.module);
                File directory = moduleFile.getAbsoluteFile().getParentFile();
                List<Module> list3 = moduleScript.getModules();
                Intrinsics.checkExpressionValueIsNotNull(list3, "moduleScript.modules");
                File file3 = directory;
                Intrinsics.checkExpressionValueIsNotNull(file3, "directory");
                KotlinToJVMBytecodeCompiler.INSTANCE.configureSourceRoots(configuration, list3, file3);
                configuration.put(JVMConfigurationKeys.MODULE_XML_FILE, moduleFile);
                KotlinCoreEnvironment environment2 = this.createCoreEnvironment(rootDisposable, configuration);
                if (messageCollector.hasErrors()) {
                    return ExitCode.COMPILATION_ERROR;
                }
                File file4 = directory;
                Intrinsics.checkExpressionValueIsNotNull(file4, "directory");
                KotlinToJVMBytecodeCompiler.INSTANCE.compileModules(environment2, file4);
            } else {
                if (arguments.script) {
                    List<String> scriptArgs = arguments.freeArgs.subList(1, arguments.freeArgs.size());
                    configuration.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, true);
                    KotlinCoreEnvironment environment3 = this.createCoreEnvironment(rootDisposable, configuration);
                    if (messageCollector.hasErrors()) {
                        return ExitCode.COMPILATION_ERROR;
                    }
                    KotlinPaths kotlinPaths2 = paths;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinPaths2, "paths");
                    return KotlinToJVMBytecodeCompiler.INSTANCE.compileAndExecuteScript(environment3, kotlinPaths2, scriptArgs);
                }
                if (destination != null) {
                    if (StringsKt.endsWith$default(destination, ".jar", false, 2, null)) {
                        configuration.put(JVMConfigurationKeys.OUTPUT_JAR, new File(destination));
                    } else {
                        configuration.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(destination));
                    }
                }
                KotlinCoreEnvironment environment4 = this.createCoreEnvironment(rootDisposable, configuration);
                if (messageCollector.hasErrors()) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (environment4.getSourceFiles().isEmpty()) {
                    if (arguments.version) {
                        return ExitCode.OK;
                    }
                    messageCollector.report(CompilerMessageSeverity.ERROR, "No source files", CompilerMessageLocation.NO_LOCATION);
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.INSTANCE.compileBunchOfSources(environment4);
            }
            if (arguments.reportPerf) {
                Companion.reportGCTime(configuration);
                Companion.reportCompilationTime(configuration);
                PerformanceCounter.Companion.report((Function1<? super String, Unit>)new Function1<String, Unit>(configuration){
                    final /* synthetic */ CompilerConfiguration $configuration;

                    public final void invoke(@NotNull String s) {
                        Intrinsics.checkParameterIsNotNull(s, "s");
                        K2JVMCompiler.Companion.reportPerf(this.$configuration, s);
                    }
                    {
                        this.$configuration = compilerConfiguration;
                        super(1);
                    }
                });
            }
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration) {
        List<String> list2 = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list2, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        KotlinCoreEnvironment result2 = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, list2);
        if (K2JVMCompiler.Companion.getInitStartNanos() != 0L) {
            long initNanos = System.nanoTime() - K2JVMCompiler.Companion.getInitStartNanos();
            Companion.reportPerf(configuration, "INIT: Compiler initialized in " + TimeUnit.NANOSECONDS.toMillis(initNanos) + " ms");
            K2JVMCompiler.Companion.setInitStartNanos(0L);
        }
        return result2;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JVMCompilerArguments arguments, @NotNull Services services) {
        IncrementalCompilationComponents components;
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(arguments, "arguments");
        Intrinsics.checkParameterIsNotNull(services, "services");
        if (IncrementalCompilation.isEnabled() && (components = services.get(IncrementalCompilationComponents.class)) != null) {
            configuration.put(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, components);
        }
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments result2 = new K2JVMCompilerArguments();
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            result2.reportPerf = true;
        }
        return result2;
    }

    static {
        Companion = new Companion(null);
        initStartNanos = System.nanoTime();
        elapsedGCTime = MapsKt.hashMapOf(new Pair[0]);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001b\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\"\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u0019J \u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "()V", "elapsedGCTime", "Ljava/util/HashMap;", "", "", "getElapsedGCTime", "()Ljava/util/HashMap;", "elapsedJITTime", "getElapsedJITTime", "()J", "setElapsedJITTime", "(J)V", "initStartNanos", "getInitStartNanos", "setInitStartNanos", "getClasspath", "", "Ljava/io/File;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "main", "", "args", "", "([Ljava/lang/String;)V", "putAdvancedOptions", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "reportCompilationTime", "reportGCTime", "reportPerf", "message", "resetInitStartTime", "setupJdkClasspathRoots", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "kotlin-compiler"})
    public static final class Companion {
        private final long getInitStartNanos() {
            return initStartNanos;
        }

        private final void setInitStartNanos(long l) {
            initStartNanos = l;
        }

        private final HashMap<String, Long> getElapsedGCTime() {
            return elapsedGCTime;
        }

        private final long getElapsedJITTime() {
            return elapsedJITTime;
        }

        private final void setElapsedJITTime(long l) {
            elapsedJITTime = l;
        }

        public final void resetInitStartTime() {
            if (this.getInitStartNanos() == 0L) {
                this.setInitStartNanos(System.nanoTime());
            }
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(args, "args");
            CLICompiler.doMain(new K2JVMCompiler(), args);
        }

        public final void reportPerf(@NotNull CompilerConfiguration configuration, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(message, "message");
            if (!configuration.getBoolean(CLIConfigurationKeys.REPORT_PERF)) {
                return;
            }
            MessageCollector collector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            collector2.report(CompilerMessageSeverity.INFO, "PERF: " + message, CompilerMessageLocation.NO_LOCATION);
        }

        public final void reportGCTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Iterable $receiver$iv = ManagementFactory.getGarbageCollectorMXBeans();
            for (Object element$iv : $receiver$iv) {
                String string;
                String string2;
                GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
                long currentTime = it.getCollectionTime();
                Map map2 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.name");
                Object object = map2.get(string2);
                if (object == null) {
                    object = 0L;
                }
                long elapsedTime = ((Number)object).longValue();
                long time = currentTime - elapsedTime;
                Companion.reportPerf(configuration, "GC time for " + it.getName() + " is " + time + " ms");
                Map map3 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.name");
                Long l = currentTime;
                map3.put(string, l);
            }
        }

        public final void reportCompilationTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (compilationMXBean == null) {
                return;
            }
            CompilationMXBean bean = compilationMXBean;
            long currentTime = bean.getTotalCompilationTime();
            this.reportPerf(configuration, "JIT time is " + (currentTime - this.getElapsedJITTime()) + " ms");
            this.setElapsedJITTime(currentTime);
        }

        private final void putAdvancedOptions(CompilerConfiguration configuration, K2JVMCompilerArguments arguments) {
            block0: {
                configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments.noCallAssertions);
                configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments.noParamAssertions);
                configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments.noOptimize);
                configuration.put(JVMConfigurationKeys.INHERIT_MULTIFILE_PARTS, arguments.inheritMultifileParts);
                configuration.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments.allowKotlinPackage);
                configuration.put(CLIConfigurationKeys.REPORT_PERF, arguments.reportPerf);
                configuration.put(JVMConfigurationKeys.LOAD_SCRIPT_CONFIGS, arguments.loadScriptConfigs);
                String string = arguments.declarationsOutputPath;
                if (string == null) break block0;
                String string2 = string;
                String it = string2;
                configuration.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, it);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<File> getClasspath(KotlinPaths paths, K2JVMCompilerArguments arguments) {
            ArrayList<File> classpath = CollectionsKt.arrayListOf(new File[0]);
            if (arguments.classpath != null) {
                List list2;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = StringsKt.split$default((CharSequence)arguments.classpath, new char[]{File.pathSeparatorChar}, false, 0, 6, null);
                ArrayList<File> arrayList = classpath;
                void var6_6 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    list2 = destination$iv$iv;
                    File file2 = new File((String)it);
                    list2.add(file2);
                }
                list2 = (List)destination$iv$iv;
                arrayList.addAll(list2);
            }
            if (!arguments.noStdlib) {
                classpath.add(paths.getRuntimePath());
            }
            return classpath;
        }

        private final ExitCode setupJdkClasspathRoots(K2JVMCompilerArguments arguments, CompilerConfiguration configuration, MessageCollector messageCollector) {
            try {
                if (!arguments.noJdk) {
                    if (arguments.jdkHome != null) {
                        messageCollector.report(CompilerMessageSeverity.LOGGING, "Using JDK home directory " + arguments.jdkHome, CompilerMessageLocation.NO_LOCATION);
                        List<File> classesRoots = PathUtil.getJdkClassesRoots(new File(arguments.jdkHome));
                        if (classesRoots.isEmpty()) {
                            messageCollector.report(CompilerMessageSeverity.ERROR, "No class roots are found in the JDK path: " + arguments.jdkHome, CompilerMessageLocation.NO_LOCATION);
                            return ExitCode.COMPILATION_ERROR;
                        }
                        List<File> list2 = classesRoots;
                        Intrinsics.checkExpressionValueIsNotNull(list2, "classesRoots");
                        JvmContentRootsKt.addJvmClasspathRoots(configuration, list2);
                    } else {
                        List<File> list3 = PathUtil.getJdkClassesRoots();
                        Intrinsics.checkExpressionValueIsNotNull(list3, "PathUtil.getJdkClassesRoots()");
                        JvmContentRootsKt.addJvmClasspathRoots(configuration, list3);
                    }
                } else if (arguments.jdkHome != null) {
                    messageCollector.report(CompilerMessageSeverity.WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", CompilerMessageLocation.NO_LOCATION);
                }
            }
            catch (Throwable t) {
                MessageCollectorUtil.reportException(messageCollector, t);
                return ExitCode.INTERNAL_ERROR;
            }
            return ExitCode.OK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

