/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.ProjectScopeBuilder;

public class ProjectScope {
    private static final Key<GlobalSearchScope> ALL_SCOPE_KEY = new Key("ALL_SCOPE_KEY");
    private static final Key<GlobalSearchScope> PROJECT_SCOPE_KEY = new Key("PROJECT_SCOPE_KEY");
    private static final Key<GlobalSearchScope> LIBRARIES_SCOPE_KEY = new Key("LIBRARIES_SCOPE_KEY");
    private static final Key<GlobalSearchScope> CONTENT_SCOPE_KEY = new Key("CONTENT_SCOPE_KEY");

    private ProjectScope() {
    }

    @NotNull
    public static GlobalSearchScope getAllScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getAllScope"));
        }
        GlobalSearchScope cached = project.getUserData(ALL_SCOPE_KEY);
        GlobalSearchScope globalSearchScope = cached != null ? cached : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(ALL_SCOPE_KEY, ProjectScopeBuilder.getInstance(project).buildAllScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getAllScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getProjectScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getProjectScope"));
        }
        GlobalSearchScope cached = project.getUserData(PROJECT_SCOPE_KEY);
        GlobalSearchScope globalSearchScope = cached != null ? cached : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(PROJECT_SCOPE_KEY, ProjectScopeBuilder.getInstance(project).buildProjectScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getProjectScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getLibrariesScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getLibrariesScope"));
        }
        GlobalSearchScope cached = project.getUserData(LIBRARIES_SCOPE_KEY);
        GlobalSearchScope globalSearchScope = cached != null ? cached : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(LIBRARIES_SCOPE_KEY, ProjectScopeBuilder.getInstance(project).buildLibrariesScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getContentScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getContentScope"));
        }
        GlobalSearchScope cached = project.getUserData(CONTENT_SCOPE_KEY);
        GlobalSearchScope globalSearchScope = cached != null ? cached : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(CONTENT_SCOPE_KEY, ProjectScopeBuilder.getInstance(project).buildContentScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getContentScope"));
        }
        return globalSearchScope;
    }
}

