/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.CompressionUtil;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUMap;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.FileChunkKey;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.LimitedInputStream;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentBTreeEnumerator;
import org.jetbrains.kotlin.gnu.trove.TLongArrayList;

public class CompressedAppendableFile {
    private final File myBaseFile;
    private byte[] myNextChunkBuffer;
    private int myBufferPosition;
    private boolean myDirty;
    private short[] myChunkLengthTable;
    private int myChunkTableLength;
    private long[] myChunkOffsetTable;
    private static final boolean doDebug = SystemProperties.getBooleanProperty("idea.compressed.file.self.check", false);
    private TLongArrayList myCompressedChunksFileOffsets = doDebug ? new TLongArrayList() : null;
    private long myFileLength;
    private long myUncompressedFileLength = -1L;
    protected final int myAppendBufferLength;
    private final LowMemoryWatcher myLowMemoryWatcher;
    private static final FileChunkReadCache ourDecompressedCache = new FileChunkReadCache();

    public CompressedAppendableFile(File file2) {
        this(file2, PersistentBTreeEnumerator.PAGE_SIZE);
    }

    private CompressedAppendableFile(File file2, int bufferSize) {
        this.myBaseFile = file2;
        this.myAppendBufferLength = bufferSize;
        assert (bufferSize <= 65535);
        this.myLowMemoryWatcher = LowMemoryWatcher.register(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompressedAppendableFile compressedAppendableFile = CompressedAppendableFile.this;
                synchronized (compressedAppendableFile) {
                    CompressedAppendableFile.this.force();
                    CompressedAppendableFile.access$002(CompressedAppendableFile.this, null);
                    CompressedAppendableFile.this.myChunkTableLength = 0;
                    CompressedAppendableFile.access$202(CompressedAppendableFile.this, null);
                    CompressedAppendableFile.access$302(CompressedAppendableFile.this, null);
                    CompressedAppendableFile.this.myBufferPosition = 0;
                    if (doDebug) {
                        CompressedAppendableFile.this.myCompressedChunksFileOffsets.clear();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <Data> Data read(long addr, KeyDescriptor<Data> descriptor2) throws IOException {
        DataInputStream stream2 = this.getStream(addr);
        try {
            Object t = descriptor2.read(stream2);
            return (Data)t;
        }
        finally {
            stream2.close();
        }
    }

    @NotNull
    public synchronized DataInputStream getStream(long addr) throws IOException {
        this.initChunkLengthTable();
        this.loadAppendBuffer();
        DataInputStream dataInputStream = new DataInputStream(new SegmentedChunkInputStream(addr, this.myChunkTableLength, this.myNextChunkBuffer, this.myBufferPosition));
        if (dataInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile", "getStream"));
        }
        return dataInputStream;
    }

    protected File getChunkLengthFile() {
        return new File(this.myBaseFile.getPath() + ".s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initChunkLengthTable() throws IOException {
        if (this.myChunkLengthTable != null) {
            return;
        }
        File chunkLengthFile = this.getChunkLengthFile();
        if (chunkLengthFile.exists()) {
            DataInputStream chunkLengthStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(new FileInputStream(chunkLengthFile), (int)chunkLengthFile.length()){

                @Override
                public int available() throws IOException {
                    return this.remainingLimit();
                }
            }, 32768));
            try {
                short[] chunkLengthTable = new short[(int)(chunkLengthFile.length() / 2L)];
                int chunkLengthTableLength = 0;
                long o = 0L;
                while (chunkLengthStream.available() != 0) {
                    int chunkLength = DataInputOutputUtil.readINT(chunkLengthStream);
                    o += (long)chunkLength;
                    if (chunkLengthTableLength == chunkLengthTable.length) {
                        chunkLengthTable = CompressedAppendableFile.reallocShortTable(chunkLengthTable);
                    }
                    chunkLengthTable[chunkLengthTableLength++] = (short)chunkLength;
                    if (!doDebug) continue;
                    this.myCompressedChunksFileOffsets.add(o);
                }
                this.myChunkLengthTable = chunkLengthTable;
                this.myChunkTableLength = chunkLengthTableLength;
                if (this.myChunkTableLength >= 32) {
                    int i;
                    long[] chunkOffsetTable = new long[this.myChunkTableLength / 32];
                    long offset2 = 0L;
                    for (i = 0; i < chunkOffsetTable.length; ++i) {
                        int start = i * 32;
                        for (int j = 0; j < 32; ++j) {
                            offset2 += (long)(chunkLengthTable[start + j] & 0xFFFF);
                        }
                        chunkOffsetTable[i] = offset2;
                    }
                    this.myChunkOffsetTable = chunkOffsetTable;
                    if (doDebug) {
                        for (i = 0; i < chunkLengthTableLength; ++i) {
                            this.calcOffsetOfPage(i);
                        }
                    }
                } else {
                    this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
                }
                this.myFileLength = this.calcOffsetOfPage(this.myChunkTableLength - 1);
            }
            finally {
                try {
                    chunkLengthStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.myChunkLengthTable = ArrayUtil.EMPTY_SHORT_ARRAY;
        this.myChunkTableLength = 0;
        this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
        this.myFileLength = 0L;
        if (this.myUncompressedFileLength == -1L) {
            long tempFileLength = this.getIncompleteChunkFile().length();
            this.myUncompressedFileLength = (long)this.myChunkTableLength * (long)this.myAppendBufferLength + tempFileLength;
            if (this.myUncompressedFileLength != this.myFileLength + tempFileLength && CompressionUtil.DUMP_COMPRESSION_STATS) {
                System.out.println(this.myUncompressedFileLength + "->" + (this.myFileLength + tempFileLength) + " for " + this.myBaseFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized byte[] loadChunk(int chunkNumber) throws IOException {
        try {
            if (this.myChunkLengthTable == null) {
                this.initChunkLengthTable();
            }
            assert (chunkNumber < this.myChunkTableLength);
            DataInputStream keysStream = this.getChunkStream(this.getChunksFile(), chunkNumber);
            try {
                if (keysStream.available() > 0) {
                    byte[] decompressedBytes = this.decompress(keysStream);
                    if (decompressedBytes.length != this.myAppendBufferLength) assert (false);
                    byte[] byArray = decompressedBytes;
                    return byArray;
                }
            }
            finally {
                try {
                    keysStream.close();
                }
                catch (IOException iOException) {}
            }
            assert (false) : "data corruption detected:" + chunkNumber + "," + this.myChunkTableLength;
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        catch (AssertionError ae) {
            throw new IOException((Throwable)((Object)ae));
        }
    }

    @NotNull
    private DataInputStream getChunkStream(File appendFile, int pageNumber) throws IOException {
        int limit;
        long pageStartOffset;
        long pageEndOffset;
        assert (this.myFileLength != 0L);
        long l = pageEndOffset = pageNumber < this.myChunkTableLength ? this.calcOffsetOfPage(pageNumber) : this.myFileLength;
        if (pageNumber > 0) {
            pageStartOffset = this.calcOffsetOfPage(pageNumber - 1);
            limit = (int)(pageEndOffset - pageStartOffset);
        } else {
            pageStartOffset = 0L;
            limit = (int)pageEndOffset;
        }
        DataInputStream dataInputStream = new DataInputStream(this.getChunkInputStream(appendFile, pageStartOffset, limit));
        if (dataInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile", "getChunkStream"));
        }
        return dataInputStream;
    }

    private long calcOffsetOfPage(int pageNumber) {
        int calculatedOffset = (pageNumber + 1) / 32;
        long offset2 = calculatedOffset > 0 ? this.myChunkOffsetTable[calculatedOffset - 1] : 0L;
        int baseOffset = calculatedOffset * 32;
        int len = (pageNumber + 1) % 32;
        for (int index2 = 0; index2 < len; ++index2) {
            offset2 += (long)(this.myChunkLengthTable[baseOffset + index2] & 0xFFFF);
        }
        if (doDebug) assert (this.myCompressedChunksFileOffsets.get(pageNumber) == offset2);
        return offset2;
    }

    @NotNull
    protected InputStream getChunkInputStream(File appendFile, long offset2, int pageSize) throws IOException {
        FileInputStream in = new FileInputStream(appendFile);
        if (offset2 > 0L) {
            in.skip(offset2);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new LimitedInputStream(in, pageSize){

            @Override
            public int available() throws IOException {
                return this.remainingLimit();
            }
        }, 32768);
        if (bufferedInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile", "getChunkInputStream"));
        }
        return bufferedInputStream;
    }

    public synchronized void append(byte[] buffer, int size) throws IOException {
        int bytesToWriteInTheBuffer;
        int newBufferSize;
        if (size == 0) {
            return;
        }
        if (this.myNextChunkBuffer == null) {
            this.loadAppendBuffer();
        }
        if ((newBufferSize = this.calcBufferSize(this.myBufferPosition + size)) != this.myNextChunkBuffer.length) {
            this.myNextChunkBuffer = Arrays.copyOf(this.myNextChunkBuffer, newBufferSize);
        }
        int bufferPosition = 0;
        for (int sizeToWrite = size; sizeToWrite > 0; sizeToWrite -= bytesToWriteInTheBuffer) {
            bytesToWriteInTheBuffer = Math.min(this.myNextChunkBuffer.length - this.myBufferPosition, sizeToWrite);
            System.arraycopy(buffer, bufferPosition, this.myNextChunkBuffer, this.myBufferPosition, bytesToWriteInTheBuffer);
            this.myBufferPosition += bytesToWriteInTheBuffer;
            bufferPosition += bytesToWriteInTheBuffer;
            this.saveNextChunkIfNeeded();
        }
        this.myUncompressedFileLength += (long)size;
        this.myDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadAppendBuffer() throws IOException {
        if (this.myNextChunkBuffer != null) {
            return;
        }
        this.myNextChunkBuffer = new byte[this.myAppendBufferLength];
        File tempAppendFile = this.getIncompleteChunkFile();
        if (tempAppendFile.exists()) {
            this.myBufferPosition = (int)tempAppendFile.length();
            this.myNextChunkBuffer = new byte[this.calcBufferSize(this.myBufferPosition)];
            FileInputStream stream2 = new FileInputStream(tempAppendFile);
            try {
                stream2.read(this.myNextChunkBuffer, 0, this.myBufferPosition);
            }
            finally {
                try {
                    stream2.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.myBufferPosition = 0;
        this.myNextChunkBuffer = new byte[1024];
    }

    private int calcBufferSize(int position) {
        return Math.min(this.myAppendBufferLength, Integer.highestOneBit(Math.max(1023, position)) << 1);
    }

    private void saveNextChunkIfNeeded() throws IOException {
        if (this.myBufferPosition == this.myNextChunkBuffer.length) {
            BufferExposingByteArrayOutputStream compressedOut = new BufferExposingByteArrayOutputStream();
            DataOutputStream compressedDataOut = new DataOutputStream(compressedOut);
            this.compress(compressedDataOut, this.myNextChunkBuffer);
            compressedDataOut.close();
            assert (compressedDataOut.size() <= 65535);
            this.saveChunk(compressedOut, this.myFileLength);
            this.myBufferPosition = 0;
            this.initChunkLengthTable();
            this.myFileLength += (long)compressedOut.size();
            if (doDebug) {
                this.myCompressedChunksFileOffsets.add(this.myFileLength);
            }
            if (this.myChunkLengthTable.length == this.myChunkTableLength) {
                this.myChunkLengthTable = CompressedAppendableFile.reallocShortTable(this.myChunkLengthTable);
            }
            this.myChunkLengthTable[this.myChunkTableLength++] = (short)compressedOut.size();
            if (this.myChunkTableLength / 32 > this.myChunkOffsetTable.length) {
                long[] newChunkOffsetTable = new long[this.myChunkOffsetTable.length + 1];
                System.arraycopy(this.myChunkOffsetTable, 0, newChunkOffsetTable, 0, this.myChunkOffsetTable.length);
                newChunkOffsetTable[this.myChunkOffsetTable.length] = this.myFileLength;
                this.myChunkOffsetTable = newChunkOffsetTable;
            }
            byte[] bytes = new byte[this.myAppendBufferLength];
            System.arraycopy(this.myNextChunkBuffer, 0, bytes, 0, this.myAppendBufferLength);
            ourDecompressedCache.put(this, this.myChunkTableLength - 1, bytes);
        }
    }

    private static short[] reallocShortTable(short[] table) {
        short[] newTable = new short[Math.max(table.length * 8 / 5, table.length + 1)];
        System.arraycopy(table, 0, newTable, 0, table.length);
        return newTable;
    }

    protected int compress(DataOutputStream compressedDataOut, byte[] buffer) throws IOException {
        return CompressionUtil.writeCompressedWithoutOriginalBufferLength(compressedDataOut, buffer, this.myAppendBufferLength);
    }

    protected byte[] decompress(DataInputStream keysStream) throws IOException {
        return CompressionUtil.readCompressedWithoutOriginalBufferLength(keysStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveChunk(BufferExposingByteArrayOutputStream compressedChunk, long endOfFileOffset) throws IOException {
        DataOutputStream stream2 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunksFile(), true)));
        try {
            stream2.write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
        }
        finally {
            try {
                stream2.close();
            }
            catch (IOException iOException) {}
        }
        DataOutputStream chunkLengthStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunkLengthFile(), true)));
        try {
            DataInputOutputUtil.writeINT(chunkLengthStream, compressedChunk.size());
        }
        finally {
            try {
                chunkLengthStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    protected File getChunksFile() {
        File file2 = new File(this.myBaseFile.getPath() + ".a");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile", "getChunksFile"));
        }
        return file2;
    }

    private void saveIncompleteChunk() {
        if (this.myNextChunkBuffer != null && this.myBufferPosition != 0 && this.myDirty) {
            block10: {
                try {
                    this.saveNextChunkIfNeeded();
                    if (this.myBufferPosition == 0) break block10;
                    BufferedOutputStream stream2 = new BufferedOutputStream(new FileOutputStream(this.getIncompleteChunkFile()));
                    try {
                        stream2.write(this.myNextChunkBuffer, 0, this.myBufferPosition);
                    }
                    finally {
                        try {
                            stream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.myDirty = false;
        }
    }

    @NotNull
    private File getIncompleteChunkFile() {
        File file2 = new File(this.myBaseFile.getPath() + ".at");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile", "getIncompleteChunkFile"));
        }
        return file2;
    }

    public synchronized void force() {
        this.saveIncompleteChunk();
    }

    public synchronized void dispose() {
        this.force();
    }

    public synchronized long length() {
        if (this.myUncompressedFileLength == -1L && this.myChunkLengthTable == null) {
            try {
                this.initChunkLengthTable();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.myUncompressedFileLength;
    }

    static /* synthetic */ short[] access$002(CompressedAppendableFile x0, short[] x1) {
        x0.myChunkLengthTable = x1;
        return x1;
    }

    static /* synthetic */ long[] access$202(CompressedAppendableFile x0, long[] x1) {
        x0.myChunkOffsetTable = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(CompressedAppendableFile x0, byte[] x1) {
        x0.myNextChunkBuffer = x1;
        return x1;
    }

    private class SegmentedChunkInputStream
    extends InputStream {
        private final long myAddr;
        private final int myChunkLengthTableSnapshotLength;
        private final byte[] myNextChunkBufferSnapshot;
        private final int myBufferPositionSnapshot;
        private InputStream bytesFromCompressedBlock;
        private InputStream bytesFromTempAppendBlock;
        private int myCurrentPageNumber;
        private int myPageOffset;

        public SegmentedChunkInputStream(long addr, int chunkLengthTableSnapshotLength, byte[] tableRef, int position) {
            this.myAddr = addr;
            this.myChunkLengthTableSnapshotLength = chunkLengthTableSnapshotLength;
            this.myNextChunkBufferSnapshot = tableRef;
            this.myBufferPositionSnapshot = position;
            this.myCurrentPageNumber = (int)(this.myAddr / (long)CompressedAppendableFile.this.myAppendBufferLength);
            this.myPageOffset = (int)(this.myAddr % (long)CompressedAppendableFile.this.myAppendBufferLength);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.bytesFromCompressedBlock == null) {
                byte[] decompressedBytes = this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength ? ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber) : ArrayUtil.EMPTY_BYTE_ARRAY;
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, this.myPageOffset, decompressedBytes.length);
            }
            int readBytesCount = 0;
            if (this.bytesFromCompressedBlock.available() > 0) {
                readBytesCount = this.bytesFromCompressedBlock.read(b, off, len);
                this.myPageOffset += readBytesCount;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if (readBytesCount == len) {
                    return readBytesCount;
                }
            }
            while (this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength) {
                byte[] decompressedBytes = ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber);
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, 0, decompressedBytes.length);
                int read2 = this.bytesFromCompressedBlock.read(b, off + readBytesCount, len - readBytesCount);
                this.myPageOffset += read2;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if ((readBytesCount += read2) != len) continue;
                return readBytesCount;
            }
            if (this.bytesFromTempAppendBlock == null) {
                this.bytesFromTempAppendBlock = new ByteArrayInputStream(this.myNextChunkBufferSnapshot, this.myPageOffset, this.myBufferPositionSnapshot);
            }
            return readBytesCount + this.bytesFromTempAppendBlock.read(b, off + readBytesCount, len - readBytesCount);
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[]{0};
            int read2 = this.read(buf);
            if (read2 == -1) {
                return -1;
            }
            return buf[0] & 0xFF;
        }
    }

    private static class FileChunkReadCache
    extends SLRUMap<FileChunkKey<CompressedAppendableFile>, byte[]> {
        private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileChunkReadCache fileChunkReadCache = FileChunkReadCache.this;
                synchronized (fileChunkReadCache) {
                    FileChunkReadCache.this.clear();
                }
            }
        });
        private final FileChunkKey<CompressedAppendableFile> myKey = new FileChunkKey<Object>(null, 0L);

        public FileChunkReadCache() {
            super(64, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public byte[] get(CompressedAppendableFile file2, int page) throws IOException {
            FileChunkReadCache fileChunkReadCache = this;
            // MONITORENTER : fileChunkReadCache
            this.myKey.setup(file2, page);
            byte[] bytes = (byte[])this.get(this.myKey);
            if (bytes != null) {
                // MONITOREXIT : fileChunkReadCache
                if (bytes != null) return bytes;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile$FileChunkReadCache", "get"));
            }
            // MONITOREXIT : fileChunkReadCache
            bytes = file2.loadChunk(page);
            fileChunkReadCache = this;
            // MONITORENTER : fileChunkReadCache
            this.put(file2, page, bytes);
            // MONITOREXIT : fileChunkReadCache
            if (bytes != null) return bytes;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile$FileChunkReadCache", "get"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(CompressedAppendableFile file2, long page, byte[] bytes) {
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myKey.setup(file2, page);
                this.put(this.myKey, bytes);
            }
        }
    }
}

