/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.configurers.MavenAnnotationProcessorConfigurer;
import org.jetbrains.idea.maven.importing.configurers.MavenCompilerConfigurer;
import org.jetbrains.idea.maven.importing.configurers.MavenEncodingConfigurer;
import org.jetbrains.idea.maven.importing.configurers.MavenIdeaPluginConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;

public abstract class MavenModuleConfigurer {
    private static volatile List<MavenModuleConfigurer> ourConfigurersList;

    public abstract void configure(@NotNull MavenProject var1, @NotNull Project var2, @Nullable Module var3);

    public static List<MavenModuleConfigurer> getConfigurers() {
        List<MavenModuleConfigurer> configurers = ourConfigurersList;
        if (configurers == null) {
            configurers = new ArrayList<MavenModuleConfigurer>();
            for (MavenModuleConfigurer configurer : new MavenModuleConfigurer[]{new MavenCompilerConfigurer(), new MavenEncodingConfigurer(), new MavenAnnotationProcessorConfigurer(), new MavenIdeaPluginConfigurer()}) {
                if (Boolean.parseBoolean(System.getProperty("idea.maven.disable." + configurer.getClass().getSimpleName()))) continue;
                configurers.add(configurer);
            }
            ourConfigurersList = configurers;
        }
        return configurers;
    }
}

