/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import java.io.IOException;
import java.net.URL;

public class LibraryItem {
    private final String name;
    private final String section;
    private final String fxmlText;
    private final URL iconURL;
    private final Library library;

    public LibraryItem(String name, String section, String fxmlText, URL iconURL, Library library) {
        assert (name != null);
        assert (fxmlText != null);
        assert (library != null);
        this.name = name;
        this.section = section;
        this.fxmlText = fxmlText;
        this.library = library;
        this.iconURL = iconURL;
    }

    public String getName() {
        return this.name;
    }

    public String getSection() {
        return this.section;
    }

    public String getFxmlText() {
        return this.fxmlText;
    }

    public URL getIconURL() {
        return this.iconURL;
    }

    public Library getLibrary() {
        return this.library;
    }

    public FXOMDocument instantiate() {
        FXOMDocument result;
        try {
            result = new FXOMDocument(this.fxmlText, null, this.library.getClassLoader(), null);
        }
        catch (IOException | Error x) {
            x.printStackTrace();
            result = null;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append('[');
        result.append(this.name);
        result.append(']');
        return result.toString();
    }
}

