/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.config.ui.CvsConfigurationPanel;
import com.intellij.cvsSupport2.ui.FormUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SshConnectionSettingsPanel {
    private TextFieldWithBrowseButton myPathToPrivateKeyFile;
    private JCheckBox myUsePrivateKeyFile;
    private JPanel myPanel;

    public SshConnectionSettingsPanel(Project project) {
        this.$$$setupUI$$$();
        CvsConfigurationPanel.addBrowseHandler(project, this.myPathToPrivateKeyFile, CvsBundle.message((String)"dialog.title.path.to.private.key.file", (Object[])new Object[0]));
        this.myUsePrivateKeyFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SshConnectionSettingsPanel.this.setPathToPPKEnabled();
            }
        });
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void updateFrom(SshSettings sshConfiguration) {
        this.myUsePrivateKeyFile.setSelected(sshConfiguration.USE_PPK);
        this.myPathToPrivateKeyFile.setText(sshConfiguration.PATH_TO_PPK);
        this.setPathToPPKEnabled();
    }

    private void setPathToPPKEnabled() {
        if (!this.myUsePrivateKeyFile.isSelected()) {
            this.myPathToPrivateKeyFile.setEnabled(false);
        } else {
            this.myPathToPrivateKeyFile.setEnabled(true);
            this.myPathToPrivateKeyFile.getTextField().selectAll();
            this.myPathToPrivateKeyFile.getTextField().requestFocus();
        }
    }

    public void saveTo(SshSettings sshConfiguration) {
        sshConfiguration.USE_PPK = this.myUsePrivateKeyFile.isSelected();
        sshConfiguration.PATH_TO_PPK = FormUtils.getFieldValue(this.myPathToPrivateKeyFile, sshConfiguration.USE_PPK);
    }

    public boolean equalsTo(SshSettings sshConfiguration) {
        if (sshConfiguration.USE_PPK != this.myUsePrivateKeyFile.isSelected()) {
            return false;
        }
        return sshConfiguration.PATH_TO_PPK.equals(this.myPathToPrivateKeyFile.getText().trim());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("border.title.configure.ssh.private.key.file"), (int)0, (int)0, null, null));
        this.myUsePrivateKeyFile = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.configure.ssh.use.private.key.file"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPathToPrivateKeyFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.configure.ext.path.to.private.key.file"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

