/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.options.ConfigurableUi;
import java.awt.Component;
import java.nio.file.Path;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsConfigurableForm;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/settingsRepository/IcsConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "()V", "panel", "Lorg/jetbrains/settingsRepository/IcsConfigurableForm;", "readOnlyEditor", "apply", "", "settings", "getComponent", "Ljavax/swing/JPanel;", "kotlin.jvm.PlatformType", "isModified", "", "reset", "settings-repository"})
public final class IcsConfigurableUi
implements ConfigurableUi<IcsSettings> {
    private final IcsConfigurableForm panel = new IcsConfigurableForm();
    private final ConfigurableUi<IcsSettings> readOnlyEditor = ReadOnlySourcesEditorKt.createReadOnlySourcesEditor();

    public void reset(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.panel.autoSyncCheckBox.setSelected(settings.getAutoSync());
        this.readOnlyEditor.reset((Object)settings);
    }

    public boolean isModified(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return this.panel.autoSyncCheckBox.isSelected() != settings.getAutoSync() || this.readOnlyEditor.isModified((Object)settings);
    }

    public void apply(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        settings.setAutoSync(this.panel.autoSyncCheckBox.isSelected());
        this.readOnlyEditor.apply((Object)settings);
        Path path = IcsManagerKt.getIcsManager().getSettingsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"icsManager.settingsFile");
        IcsSettingsKt.saveSettings(settings, path);
    }

    public JPanel getComponent() {
        return this.panel.rootPanel;
    }

    public IcsConfigurableUi() {
        this.panel.readOnlySourcesPanel.add((Component)this.readOnlyEditor.getComponent(), "Center");
    }
}

