/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestClassesFilter;
import com.intellij.util.containers.MultiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GroupBasedTestClassFilter
extends TestClassesFilter {
    public static final String ALL_EXCLUDE_DEFINED = "ALL_EXCLUDE_DEFINED";
    private final MultiMap<String, Pattern> myPatterns = MultiMap.create();
    private final List<Pattern> myAllPatterns = new ArrayList<Pattern>();
    private final List<Pattern> myTestGroupPatterns;
    private boolean myContainsAllExcludeDefinedGroup;

    public GroupBasedTestClassFilter(MultiMap<String, String> filters, List<String> testGroupNames) {
        this.myContainsAllExcludeDefinedGroup = GroupBasedTestClassFilter.containsAllExcludeDefinedGroup(testGroupNames);
        for (String groupName : filters.keySet()) {
            this.addPatterns(groupName, filters.get((Object)groupName));
        }
        this.myTestGroupPatterns = this.collectPatternsFor(testGroupNames);
    }

    private void addPatterns(String groupName, Collection<String> filterList) {
        ArrayList<Pattern> patterns = GroupBasedTestClassFilter.compilePatterns(filterList);
        this.myPatterns.putValues((Object)groupName, patterns);
        this.myAllPatterns.addAll(patterns);
    }

    @NotNull
    public static TestClassesFilter createOn(@NotNull Reader reader, @NotNull List<String> testGroupNames) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/GroupBasedTestClassFilter", "createOn"));
        }
        if (testGroupNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testGroupNames", "com/intellij/GroupBasedTestClassFilter", "createOn"));
        }
        GroupBasedTestClassFilter groupBasedTestClassFilter = new GroupBasedTestClassFilter(GroupBasedTestClassFilter.readGroups(reader), testGroupNames);
        if (groupBasedTestClassFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/GroupBasedTestClassFilter", "createOn"));
        }
        return groupBasedTestClassFilter;
    }

    public static MultiMap<String, String> readGroups(Reader reader) throws IOException {
        String line;
        MultiMap groupNameToPatternsMap = MultiMap.createLinked();
        String currentGroupName = "";
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                currentGroupName = line.substring(1, line.length() - 1);
                continue;
            }
            groupNameToPatternsMap.putValue((Object)currentGroupName, (Object)line);
        }
        return groupNameToPatternsMap;
    }

    @Override
    public boolean matches(String className, String moduleName) {
        if (GroupBasedTestClassFilter.matchesAnyPattern(this.myTestGroupPatterns, className)) {
            return true;
        }
        return this.myContainsAllExcludeDefinedGroup && !GroupBasedTestClassFilter.matchesAnyPattern(this.myAllPatterns, className);
    }

    private static boolean containsAllExcludeDefinedGroup(List<String> groupNames) {
        return groupNames.isEmpty() || groupNames.contains(ALL_EXCLUDE_DEFINED);
    }

    private List<Pattern> collectPatternsFor(List<String> groupNames) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String groupName : groupNames) {
            patterns.addAll(this.myPatterns.get((Object)groupName));
        }
        return patterns;
    }
}

