/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class ImportSourceChooserDialog<S extends Scheme>
extends DialogWrapper {
    private JPanel myContentPane;
    private JBList mySourceList;
    private String mySelectedSourceName;
    private final ListModel myListModel;
    private static final String SHARED_IMPORT_SOURCE = ApplicationBundle.message((String)"import.scheme.shared", (Object[])new Object[0]);

    public ImportSourceChooserDialog(JComponent parent, Class<S> schemeClass) {
        super((Component)parent, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(ApplicationBundle.message((String)"title.import.scheme.from", (Object[])objectArray));
        this.myListModel = new SourceListModel(SchemeImporterEP.getExtensions(schemeClass));
        this.initSourceList();
        this.init();
    }

    private void initSourceList() {
        this.mySourceList.setModel(this.myListModel);
        this.mySourceList.setSelectionMode(0);
        this.mySourceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ImportSourceChooserDialog.this.mySourceList.getSelectedIndex();
                if (index >= 0) {
                    ImportSourceChooserDialog.this.setSelectedSourceName((String)ImportSourceChooserDialog.this.myListModel.getElementAt(index));
                }
            }
        });
        this.mySourceList.setSelectedIndex(0);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void setSelectedSourceName(String name) {
        this.mySelectedSourceName = name;
    }

    @Nullable
    public String getSelectedSourceName() {
        return this.mySelectedSourceName;
    }

    public boolean isImportFromSharedSelected() {
        return SHARED_IMPORT_SOURCE.equals(this.mySelectedSourceName);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.mySourceList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class SourceListModel
    extends DefaultListModel {
        private final List<String> mySourceNames = new ArrayList<String>();

        public SourceListModel(Collection<SchemeImporterEP<S>> extensions) {
            for (SchemeImporterEP extension : extensions) {
                this.mySourceNames.add(extension.name);
            }
        }

        @Override
        public int getSize() {
            return this.mySourceNames.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.mySourceNames.get(index);
        }
    }
}

