/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressByJavaCommentFix
extends SuppressByCommentFix {
    public SuppressByJavaCommentFix(@NotNull HighlightDisplayKey key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/actions/SuppressByJavaCommentFix", "<init>"));
        }
        super(key2, PsiStatement.class);
    }

    @Override
    @Nullable
    public PsiElement getContainer(PsiElement context) {
        if (SuppressByJavaCommentFix.hasJspMethodCallAsParent(context)) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class, (boolean)false);
    }

    private static boolean hasJspMethodCallAsParent(PsiElement context) {
        PsiMethod method;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class)) != null) {
            if (method instanceof SyntheticElement) {
                return true;
            }
            context = method;
        }
        return false;
    }

    @Override
    protected void createSuppression(@NotNull Project project2, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressByJavaCommentFix", "createSuppression"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/actions/SuppressByJavaCommentFix", "createSuppression"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/actions/SuppressByJavaCommentFix", "createSuppression"));
        }
        PsiElement declaredElement = this.getElementToAnnotate(element, container);
        if (declaredElement == null) {
            this.suppressWithComment(project2, element, container);
        } else {
            JavaSuppressionUtil.addSuppressAnnotation(project2, container, (PsiModifierListOwner)((PsiLocalVariable)declaredElement), this.myID);
        }
    }

    @Override
    protected boolean replaceSuppressionComments(PsiElement container) {
        if (this.getElementToAnnotate(container, container) != null) {
            return false;
        }
        return super.replaceSuppressionComments(container);
    }

    @Nullable
    protected PsiElement getElementToAnnotate(PsiElement element, PsiElement container) {
        return JavaSuppressionUtil.getElementToAnnotate(element, container);
    }

    protected void suppressWithComment(Project project2, PsiElement element, PsiElement container) {
        super.createSuppression(project2, element, container);
    }
}

