/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertSchemaPrefixToDefaultIntention
extends PsiElementBaseIntentionAction {
    public static final String NAME = "Reset to default namespace";

    public ConvertSchemaPrefixToDefaultIntention() {
        this.setText(NAME);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "invoke"));
        }
        final XmlAttribute xmlns = ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element);
        if (xmlns == null) {
            return;
        }
        SchemaPrefixReference prefixRef = null;
        for (PsiReference ref : xmlns.getReferences()) {
            if (!(ref instanceof SchemaPrefixReference)) continue;
            prefixRef = (SchemaPrefixReference)ref;
            break;
        }
        if (prefixRef == null) {
            return;
        }
        final SchemaPrefix prefix = prefixRef.resolve();
        final String ns = prefixRef.getNamespacePrefix();
        final ArrayList tags = new ArrayList();
        final ArrayList attrs = new ArrayList();
        xmlns.getParent().accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (ns.equals(tag.getNamespacePrefix())) {
                    tags.add(tag);
                }
                super.visitXmlTag(tag);
            }

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                if (value.getValue().startsWith(ns + ":")) {
                    for (PsiReference ref : value.getReferences()) {
                        if (!(ref instanceof SchemaPrefixReference) || !ref.isReferenceTo((PsiElement)prefix)) continue;
                        attrs.add((XmlAttribute)value.getParent());
                    }
                }
            }
        });
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{xmlns.getContainingFile()})) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "lambda$invoke$1"));
            }
            ConvertSchemaPrefixToDefaultIntention.convertTagsAndAttributes(ns, tags, attrs, project2);
            ApplicationManager.getApplication().runWriteAction(() -> xmlns.setName("xmlns"));
        }, NAME, null);
        new WriteCommandAction(project2, NAME, new PsiFile[]{xmlns.getContainingFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention$2", "run"));
                }
                xmlns.setName("xmlns");
            }
        }.execute();
    }

    private static void convertTagsAndAttributes(String ns, final List<XmlTag> tags, final List<XmlAttribute> attrs, Project project2) {
        final int localNameIndex = ns.length() + 1;
        final int totalCount = tags.size() + attrs.size();
        final SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, "Changing to default namespace", true);
        progressTask.setTask(new SequentialTask(){
            int tagIndex = 0;
            int attrIndex = 0;

            public void prepare() {
            }

            public boolean isDone() {
                return this.tagIndex + this.attrIndex >= totalCount;
            }

            public boolean iteration() {
                progressTask.getIndicator().setFraction((double)(this.tagIndex + this.attrIndex) / (double)totalCount);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (this.tagIndex < tags.size()) {
                        XmlTag tag;
                        String s;
                        if (!(s = (tag = (XmlTag)tags.get(this.tagIndex++)).getName().substring(localNameIndex)).isEmpty()) {
                            tag.setName(s);
                        }
                    } else if (this.attrIndex < attrs.size()) {
                        XmlAttribute attr = (XmlAttribute)attrs.get(this.attrIndex++);
                        attr.setValue(attr.getValue().substring(localNameIndex));
                    }
                });
                return this.isDone();
            }

            public void stop() {
            }
        });
        ProgressManager.getInstance().run((Task)progressTask);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "isAvailable"));
        }
        return ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "getFamilyName"));
        }
        return NAME;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        for (PsiReference ref : parent.getReferences()) {
            PsiElement tag;
            PsiElement attr;
            PsiElement elem;
            if (!(ref instanceof SchemaPrefixReference) || (elem = ref.resolve()) == null || !((attr = elem.getParent()) instanceof XmlAttribute) || !((tag = attr.getParent()) instanceof XmlTag) || ((XmlTag)tag).getAttribute("xmlns") != null) continue;
            return (XmlAttribute)attr;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

