/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlNSColorProvider;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;

public class XmlNamespaceAnnotator
implements Annotator {
    private static final XmlNSColorProvider[] PROVIDERS = (XmlNSColorProvider[])XmlNSColorProvider.EXTENSION_POINT_NAME.getExtensions();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/XmlNamespaceAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlNamespaceAnnotator", "annotate"));
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String namespace = tag.getNamespace();
            for (XmlNSColorProvider provider : PROVIDERS) {
                TextRange endTagRange;
                TextAttributesKey key2 = provider.getKeyForNamespace(namespace, (XmlElement)tag);
                if (key2 == null) continue;
                TextRange range = XmlTagUtil.getStartTagRange((XmlTag)tag);
                if (range != null) {
                    holder.createInfoAnnotation(range, null).setTextAttributes(key2);
                }
                if ((endTagRange = XmlTagUtil.getEndTagRange((XmlTag)tag)) != null) {
                    holder.createInfoAnnotation(endTagRange, null).setTextAttributes(key2);
                }
                return;
            }
        }
    }
}

