/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;

public class JavaWordSelectioner
extends AbstractWordSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        if (e instanceof PsiKeyword) {
            return true;
        }
        if (e instanceof PsiJavaToken) {
            IElementType tokenType = ((PsiJavaToken)e).getTokenType();
            return tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.STRING_LITERAL;
        }
        return false;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> ranges = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof PsiJavaToken && ((PsiJavaToken)e).getTokenType() == JavaTokenType.STRING_LITERAL) {
            JavaWordSelectioner.killRangesBreakingEscapes(e, ranges, e.getTextRange());
        }
        return ranges;
    }

    private static void killRangesBreakingEscapes(PsiElement e, List<TextRange> ranges, TextRange literalRange) {
        Iterator<TextRange> iterator = ranges.iterator();
        while (iterator.hasNext()) {
            TextRange each = iterator.next();
            if (!literalRange.contains(each) || literalRange.getStartOffset() >= each.getStartOffset() || e.getText().charAt(each.getStartOffset() - literalRange.getStartOffset() - 1) != '\\') continue;
            iterator.remove();
        }
    }
}

