/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.FileFilterPanel;
import com.intellij.codeInspection.actions.GotoInspectionModel;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.header.ProfilesComboBox;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionAction
extends GotoActionBase {
    private static final Logger LOGGER = Logger.getInstance(RunInspectionAction.class);

    public RunInspectionAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"goto.inspection.action.text", (Object[])new Object[0]));
    }

    @Override
    protected void gotoActionPerformed(AnActionEvent e) {
        final Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        final PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        final PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        final VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.inspection");
        GotoInspectionModel model = new GotoInspectionModel(project2);
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            protected ChooseByNameFilter<Object> createFilter(@NotNull ChooseByNamePopup popup) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInspection/actions/RunInspectionAction$1", "createFilter"));
                }
                popup.setSearchInAnyPlace(true);
                return super.createFilter(popup);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup, Object element) {
                ApplicationManager.getApplication().invokeLater(() -> RunInspectionAction.runInspection(project2, ((InspectionToolWrapper)element).getShortName(), virtualFile, psiElement, psiFile));
            }
        }, false);
    }

    private static void runInspection(final @NotNull Project project2, @NotNull String shortName, @Nullable VirtualFile virtualFile, PsiElement psiElement, PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionAction", "runInspection"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/actions/RunInspectionAction", "runInspection"));
        }
        PsiElement element = psiFile == null ? psiElement : psiFile;
        final InspectionProfile currentProfile = InspectionProjectProfileManager.getInstance(project2).getInspectionProfile();
        final InspectionToolWrapper toolWrapper = element != null ? currentProfile.getInspectionTool(shortName, element) : currentProfile.getInspectionTool(shortName, project2);
        LOGGER.assertTrue(toolWrapper != null, (Object)("Missed inspection: " + shortName));
        final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project2);
        final Module module2 = virtualFile != null ? ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project2) : null;
        AnalysisScope analysisScope = null;
        if (psiFile != null) {
            analysisScope = new AnalysisScope(psiFile);
        } else {
            PsiDirectory psiDirectory;
            if (virtualFile != null && virtualFile.isDirectory() && (psiDirectory = PsiManager.getInstance((Project)project2).findDirectory(virtualFile)) != null) {
                analysisScope = new AnalysisScope(psiDirectory);
            }
            if (analysisScope == null && virtualFile != null) {
                analysisScope = new AnalysisScope(project2, Arrays.asList(virtualFile));
            }
            if (analysisScope == null) {
                analysisScope = new AnalysisScope(project2);
            }
        }
        final AnalysisUIOptions options = AnalysisUIOptions.getInstance(project2);
        final FileFilterPanel fileFilterPanel = new FileFilterPanel();
        fileFilterPanel.init(options);
        final AnalysisScope initialAnalysisScope = analysisScope;
        BaseAnalysisActionDialog dialog = new BaseAnalysisActionDialog("Run '" + toolWrapper.getDisplayName() + "'", AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project2, analysisScope, module2 != null ? module2.getName() : null, true, options, psiElement){
            private InheritOptionsForToolPanel myToolOptionsPanel;

            @Override
            @Nullable
            protected JComponent getAdditionalActionSettings(Project project22) {
                JPanel fileFilter = fileFilterPanel.getPanel();
                if (toolWrapper.getTool().createOptionsPanel() != null) {
                    JPanel additionPanel = new JPanel();
                    additionPanel.setLayout(new BoxLayout(additionPanel, 1));
                    additionPanel.add(fileFilter);
                    this.myToolOptionsPanel = new InheritOptionsForToolPanel((InspectionProfileImpl)currentProfile, toolWrapper.getShortName(), project22);
                    additionPanel.add(this.myToolOptionsPanel);
                    return additionPanel;
                }
                return fileFilter;
            }

            @Override
            @NotNull
            public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project22, Module module22) {
                if (uiOptions == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiOptions", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                if (defaultScope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultScope", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                if (project22 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                AnalysisScope scope = super.getScope(uiOptions, defaultScope, project22, module22);
                GlobalSearchScope filterScope = fileFilterPanel.getSearchScope();
                if (filterScope == null) {
                    AnalysisScope analysisScope = scope;
                    if (analysisScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                    }
                    return analysisScope;
                }
                scope.setFilter(filterScope);
                AnalysisScope analysisScope = scope;
                if (analysisScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                return analysisScope;
            }

            private AnalysisScope getScope() {
                return this.getScope(options, initialAnalysisScope, project2, module2);
            }

            private InspectionToolWrapper getToolWrapper() {
                return this.myToolOptionsPanel == null ? toolWrapper : this.myToolOptionsPanel.getSelectedWrapper();
            }

            @NotNull
            protected Action[] createActions() {
                ArrayList<Action> actions = new ArrayList<Action>();
                boolean hasFixAll = toolWrapper.getTool() instanceof CleanupLocalInspectionTool;
                actions.add(new AbstractAction(hasFixAll ? AnalysisScopeBundle.message((String)"action.analyze.verb", (Object[])new Object[0]) : CommonBundle.getOkButtonText()){
                    {
                        super(x0);
                        this.putValue("DefaultAction", Boolean.TRUE);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RunInspectionIntention.rerunInspection(this.getToolWrapper(), managerEx, this.getScope(), null);
                        this.close(0);
                    }
                });
                if (hasFixAll) {
                    actions.add(new AbstractAction("Fix All"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InspectionToolWrapper wrapper = this.getToolWrapper();
                            InspectionProfileImpl cleanupToolProfile = RunInspectionIntention.createProfile(wrapper, managerEx, null);
                            managerEx.createNewGlobalContext(false).codeCleanup(this.getScope(), cleanupToolProfile, "Cleanup by " + wrapper.getDisplayName(), null, false);
                            this.close(0);
                        }
                    });
                }
                actions.add(this.getCancelAction());
                if (SystemInfo.isMac) {
                    Collections.reverse(actions);
                }
                Action[] actionArray = actions.toArray(new Action[actions.size()]);
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$2", "createActions"));
                }
                return actionArray;
            }
        };
        dialog.showAndGet();
    }

    private static class InheritOptionsForToolPanel
    extends JPanel {
        private final ProfilesComboBox myProfilesComboBox;
        private final FactoryMap<InspectionProfile, Pair<InspectionToolWrapper, JComponent>> myProfile2ModifiedWrapper;

        public InheritOptionsForToolPanel(InspectionProfileImpl initial, final String toolShortName, final Project project2) {
            this.myProfile2ModifiedWrapper = new FactoryMap<InspectionProfile, Pair<InspectionToolWrapper, JComponent>>(){

                @Nullable
                protected Pair<InspectionToolWrapper, JComponent> create(InspectionProfile profile) {
                    InspectionToolWrapper tool = profile.getInspectionTool(toolShortName, project2);
                    LOGGER.assertTrue(tool != null);
                    Element options = new Element("copy");
                    tool.getTool().writeSettings(options);
                    tool = tool.createCopy();
                    try {
                        tool.getTool().readSettings(options);
                    }
                    catch (InvalidDataException e) {
                        throw new RuntimeException(e);
                    }
                    return Pair.create((Object)tool, (Object)tool.getTool().createOptionsPanel());
                }
            };
            final JPanel settingsAnchor = new JPanel(new BorderLayout());
            this.myProfilesComboBox = new ProfilesComboBox(){

                @Override
                protected void onProfileChosen(InspectionProfileImpl inspectionProfile) {
                    settingsAnchor.removeAll();
                    settingsAnchor.add((Component)((Pair)myProfile2ModifiedWrapper.get((Object)inspectionProfile)).getSecond(), "Center");
                    settingsAnchor.invalidate();
                    settingsAnchor.validate();
                    settingsAnchor.repaint();
                }

                @Override
                protected boolean isProjectLevel(InspectionProfileImpl p) {
                    return p.isProjectLevel();
                }

                @Override
                @NotNull
                protected String getProfileName(InspectionProfileImpl p) {
                    String string = p.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$InheritOptionsForToolPanel$2", "getProfileName"));
                    }
                    return string;
                }
            };
            this.setLayout(new BoxLayout(this, 1));
            this.add((Component)new TitledSeparator(IdeBundle.message((String)"goto.inspection.action.choose.inherit.settings.from", (Object[])new Object[0])));
            this.add((Component)LabeledComponent.create((JComponent)((Object)this.myProfilesComboBox), (String)"Profile:", (String)"West"));
            this.add(Box.createVerticalStrut(JBUI.scale((int)10)));
            this.add(settingsAnchor);
            ArrayList profiles = new ArrayList();
            profiles.addAll(InspectionProfileManager.getInstance().getProfiles());
            profiles.addAll(InspectionProjectProfileManager.getInstance(project2).getProfiles());
            this.myProfilesComboBox.reset(profiles);
            this.myProfilesComboBox.selectProfile(initial);
        }

        @NotNull
        public InspectionToolWrapper getSelectedWrapper() {
            InspectionToolWrapper inspectionToolWrapper = (InspectionToolWrapper)((Pair)this.myProfile2ModifiedWrapper.get((Object)((InspectionProfileImpl)this.myProfilesComboBox.getSelectedItem()))).getFirst();
            if (inspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$InheritOptionsForToolPanel", "getSelectedWrapper"));
            }
            return inspectionToolWrapper;
        }
    }
}

