/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.HighlightingLevel;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.AbstractToggleUseSoftWrapsAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetEditorSettingsAction
extends ActionGroup
implements DumbAware {
    @NotNull
    private final TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private final List<? extends Editor> myEditors;
    @Nullable
    private SyncScrollSupport.Support mySyncScrollSupport;
    @NotNull
    private final AnAction[] myActions;

    public SetEditorSettingsAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull List<? extends Editor> editors) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/actions/impl/SetEditorSettingsAction", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/actions/impl/SetEditorSettingsAction", "<init>"));
        }
        super("Editor Settings", null, AllIcons.General.SecondaryGroup);
        this.setPopup(true);
        this.myTextSettings = settings;
        this.myEditors = editors;
        for (Editor editor : this.myEditors) {
            ((EditorGutterComponentEx)editor.getGutter()).setGutterPopupGroup(this);
        }
        this.myActions = new AnAction[]{new EditorSettingToggleAction("EditorToggleShowWhitespaces"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowWhitespaces();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowWhiteSpaces(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$1", "apply"));
                }
                if (editor.getSettings().isWhitespacesShown() != value) {
                    editor.getSettings().setWhitespacesShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleShowLineNumbers"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowLineNumbers();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowLineNumbers(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$2", "apply"));
                }
                if (editor.getSettings().isLineNumbersShown() != value) {
                    editor.getSettings().setLineNumbersShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleShowIndentLines"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowIndentLines();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowIndentLines(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$3", "apply"));
                }
                if (editor.getSettings().isIndentGuidesShown() != value) {
                    editor.getSettings().setIndentGuidesShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleUseSoftWraps"){
            private boolean myForcedSoftWrap;

            @Override
            public boolean isSelected() {
                return this.myForcedSoftWrap || SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps();
            }

            @Override
            public void setSelected(boolean state) {
                this.myForcedSoftWrap = false;
                SetEditorSettingsAction.this.myTextSettings.setUseSoftWraps(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$4", "apply"));
                }
                if (editor.getSettings().isUseSoftWraps() == value) {
                    return;
                }
                if (SetEditorSettingsAction.this.mySyncScrollSupport != null) {
                    SetEditorSettingsAction.this.mySyncScrollSupport.enterDisableScrollSection();
                }
                try {
                    AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor, null, value);
                }
                finally {
                    if (SetEditorSettingsAction.this.mySyncScrollSupport != null) {
                        SetEditorSettingsAction.this.mySyncScrollSupport.exitDisableScrollSection();
                    }
                }
            }

            @Override
            public void applyDefaults(@NotNull List<? extends Editor> editors) {
                if (editors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/actions/impl/SetEditorSettingsAction$4", "applyDefaults"));
                }
                if (!SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps()) {
                    for (Editor editor : editors) {
                        this.myForcedSoftWrap = this.myForcedSoftWrap || ((EditorImpl)editor).shouldSoftWrapsBeForced();
                    }
                }
                super.applyDefaults(editors);
            }
        }, new EditorHighlightingLayerAction()};
    }

    public void setSyncScrollSupport(@Nullable SyncScrollSupport.Support syncScrollSupport) {
        this.mySyncScrollSupport = syncScrollSupport;
    }

    public void applyDefaults() {
        for (AnAction action : this.myActions) {
            ((EditorSettingAction)action).applyDefaults(this.myEditors);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        ContainerUtil.addAll(result2, (Object[])this.myActions);
        result2.add(Separator.getInstance());
        result2.add(ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu"));
        AnAction[] anActionArray = (AnAction[])ContainerUtil.toArray(result2, (Object[])new AnAction[result2.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/SetEditorSettingsAction", "getChildren"));
        }
        return anActionArray;
    }

    private static interface EditorSettingAction {
        public void applyDefaults(@NotNull List<? extends Editor> var1);
    }

    private class EditorHighlightingLayerAction
    extends ActionGroup
    implements EditorSettingAction {
        private final AnAction[] myOptions;

        public EditorHighlightingLayerAction() {
            super("Highlighting Level", true);
            this.myOptions = (AnAction[])ContainerUtil.map((Object[])HighlightingLevel.values(), level -> new OptionAction((HighlightingLevel)((Object)level)), (Object[])AnAction.EMPTY_ARRAY);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.myOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerAction", "getChildren"));
            }
            return this.myOptions;
        }

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerAction", "applyDefaults"));
            }
            this.apply(SetEditorSettingsAction.this.myTextSettings.getHighlightingLevel());
        }

        private void apply(@NotNull HighlightingLevel layer) {
            if (layer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layer", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerAction", "apply"));
            }
            for (Editor editor : SetEditorSettingsAction.this.myEditors) {
                ((EditorImpl)editor).setHighlightingFilter(layer.getCondition());
            }
        }

        private class OptionAction
        extends ToggleAction
        implements DumbAware {
            @NotNull
            private final HighlightingLevel myLayer;

            public OptionAction(HighlightingLevel layer) {
                if (layer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layer", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerAction$OptionAction", "<init>"));
                }
                super(layer.getText(), null, layer.getIcon());
                this.myLayer = layer;
            }

            public boolean isSelected(AnActionEvent e) {
                return SetEditorSettingsAction.this.myTextSettings.getHighlightingLevel() == this.myLayer;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setHighlightingLevel(this.myLayer);
                EditorHighlightingLayerAction.this.apply(this.myLayer);
            }
        }
    }

    private abstract class EditorSettingToggleAction
    extends ToggleAction
    implements DumbAware,
    EditorSettingAction {
        private EditorSettingToggleAction(String actionId) {
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorSettingToggleAction", "<init>"));
            }
            ActionUtil.copyFrom((AnAction)this, (String)actionId);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.isSelected();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.setSelected(state);
            for (Editor editor : SetEditorSettingsAction.this.myEditors) {
                this.apply(editor, state);
            }
        }

        public abstract boolean isSelected();

        public abstract void setSelected(boolean var1);

        public abstract void apply(@NotNull Editor var1, boolean var2);

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorSettingToggleAction", "applyDefaults"));
            }
            for (Editor editor : editors) {
                this.apply(editor, this.isSelected());
            }
        }
    }
}

