/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsCompareWithBranchAction<T extends Repository>
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)DvcsCompareWithBranchAction.class.getName());

    public void actionPerformed(@NotNull AnActionEvent event) {
        String currentBranchName;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "actionPerformed"));
        }
        Project project2 = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file2 = DvcsCompareWithBranchAction.getAffectedFile(event);
        Repository repository = (Repository)ObjectUtils.assertNotNull(this.getRepositoryManager(project2).getRepositoryForFile(file2));
        assert (!repository.isFresh());
        String presentableRevisionName = currentBranchName = repository.getCurrentBranchName();
        if (currentBranchName == null) {
            String currentRevision = (String)ObjectUtils.assertNotNull((Object)repository.getCurrentRevision());
            presentableRevisionName = DvcsUtil.getShortHash(currentRevision);
        }
        List<String> branchNames = this.getBranchNamesExceptCurrent(repository);
        JBList list = new JBList(branchNames);
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select branch to compare").setItemChoosenCallback((Runnable)new OnBranchChooseRunnable(project2, file2, presentableRevisionName, (JList)list)).setAutoselectOnMouseMove(true).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return o.toString();
            }
        }).createPopup().showCenteredInCurrentWindow(project2);
    }

    @NotNull
    protected abstract List<String> getBranchNamesExceptCurrent(@NotNull T var1);

    private static VirtualFile getAffectedFile(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "getAffectedFile"));
        }
        Object[] vFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null && vFiles.length == 1 && vFiles[0] != null) : "Illegal virtual files selected: " + Arrays.toString(vFiles);
        return vFiles[0];
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "update"));
        }
        Presentation presentation = e.getPresentation();
        Project project2 = e.getProject();
        VirtualFile file2 = (VirtualFile)VcsUtil.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
        presentation.setVisible(project2 != null);
        presentation.setEnabled(project2 != null && file2 != null && this.isEnabled(this.getRepositoryManager(project2).getRepositoryForFile(file2)));
    }

    private boolean isEnabled(@Nullable T repository) {
        return repository != null && !repository.isFresh() && !this.noBranchesToCompare(repository);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<T> getRepositoryManager(@NotNull Project var1);

    protected abstract boolean noBranchesToCompare(@NotNull T var1);

    @NotNull
    protected abstract Collection<Change> getDiffChanges(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3) throws VcsException;

    private void showDiffWithBranchUnderModalProgress(final @NotNull Project project2, final @NotNull VirtualFile file2, final @NotNull String head, final @NotNull String compare) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "showDiffWithBranchUnderModalProgress"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "showDiffWithBranchUnderModalProgress"));
        }
        if (head == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "showDiffWithBranchUnderModalProgress"));
        }
        if (compare == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compare", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "showDiffWithBranchUnderModalProgress"));
        }
        new Task.Backgroundable(project2, "Collecting Changes...", true){
            private Collection<Change> changes;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$2", "run"));
                }
                try {
                    this.changes = DvcsCompareWithBranchAction.this.getDiffChanges(project2, file2, compare);
                }
                catch (VcsException e) {
                    VcsNotifier.getInstance(project2).notifyImportantWarning("Couldn't compare with branch", String.format("Couldn't compare " + DvcsUtil.fileOrFolder(file2) + " [%s] with branch [%s];\n %s", file2, compare, e.getMessage()));
                }
            }

            public void onSuccess() {
                if (this.changes != null) {
                    VcsDiffUtil.showDiffFor(project2, this.changes, VcsDiffUtil.getRevisionTitle(compare, false), VcsDiffUtil.getRevisionTitle(head, true), VcsUtil.getFilePath((VirtualFile)file2));
                }
            }
        }.queue();
    }

    protected static String fileDoesntExistInBranchError(@NotNull VirtualFile file2, @NotNull String branchToCompare) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "fileDoesntExistInBranchError"));
        }
        if (branchToCompare == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToCompare", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction", "fileDoesntExistInBranchError"));
        }
        return String.format("%s <code>%s</code> doesn't exist in branch <code>%s</code>", StringUtil.capitalize((String)DvcsUtil.fileOrFolder(file2)), file2.getPresentableUrl(), branchToCompare);
    }

    private class OnBranchChooseRunnable
    implements Runnable {
        private final Project myProject;
        private final VirtualFile myFile;
        private final String myHead;
        private final JList myList;

        private OnBranchChooseRunnable(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull String head, JList list) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$OnBranchChooseRunnable", "<init>"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$OnBranchChooseRunnable", "<init>"));
            }
            if (head == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$OnBranchChooseRunnable", "<init>"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$OnBranchChooseRunnable", "<init>"));
            }
            this.myProject = project2;
            this.myFile = file2;
            this.myHead = head;
            this.myList = list;
        }

        @Override
        public void run() {
            Object selectedValue = this.myList.getSelectedValue();
            if (selectedValue == null) {
                LOG.error("Selected value is unexpectedly null");
                return;
            }
            DvcsCompareWithBranchAction.this.showDiffWithBranchUnderModalProgress(this.myProject, this.myFile, this.myHead, selectedValue.toString());
        }
    }
}

