/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.impl.CompositeDiffPanel;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.DiscloseMultiRequest;
import com.intellij.openapi.diff.impl.external.FrameDiffTool;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.config.AbstractProperty;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class MultiLevelDiffTool
implements DiffTool,
DiscloseMultiRequest {
    public static final String ourDefaultTab = "Contents";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.external.MultiLevelDiffTool");
    private final List<DiffTool> myTools;

    public MultiLevelDiffTool(List<DiffTool> tools) {
        this.myTools = tools;
    }

    public void show(DiffRequest request) {
        Collection hints = request.getHints();
        boolean shouldOpenDialog = FrameDiffTool.shouldOpenDialog(hints);
        if (shouldOpenDialog) {
            final DialogBuilder builder = new DialogBuilder(request.getProject());
            CompositeDiffPanel diffPanel = this.createPanel(request, builder.getWindow(), (Disposable)builder);
            if (diffPanel == null) {
                Disposer.dispose((Disposable)builder);
                return;
            }
            Runnable onOkRunnable = request.getOnOkRunnable();
            if (onOkRunnable != null) {
                builder.setOkOperation(() -> {
                    builder.getDialogWrapper().close(0);
                    onOkRunnable.run();
                });
            } else {
                builder.removeAllActions();
            }
            builder.setCenterPanel(diffPanel.getComponent());
            builder.setPreferredFocusComponent(diffPanel.getPreferredFocusedComponent());
            builder.setTitle(request.getWindowTitle());
            builder.setDimensionServiceKey(request.getGroupKey());
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    builder.getDialogWrapper().close(0);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseContent")), diffPanel.getComponent());
            diffPanel.setDiffRequest(request);
            FrameDiffTool.showDiffDialog(builder, hints);
        } else {
            final FrameWrapper frameWrapper = new FrameWrapper(request.getProject(), request.getGroupKey());
            CompositeDiffPanel diffPanel = this.createPanel(request, frameWrapper.getFrame(), frameWrapper);
            if (diffPanel == null) {
                Disposer.dispose((Disposable)frameWrapper);
                return;
            }
            frameWrapper.setTitle(request.getWindowTitle());
            diffPanel.setDiffRequest(request);
            DiffUtil.initDiffFrame(request.getProject(), frameWrapper, diffPanel, diffPanel.getComponent());
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Disposer.dispose((Disposable)frameWrapper);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseContent")), diffPanel.getComponent());
            frameWrapper.show();
        }
    }

    private CompositeDiffPanel createPanel(final DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool", "createPanel"));
        }
        CompositeDiffPanel panel = new CompositeDiffPanel(request.getProject(), this, window, parentDisposable);
        request.getGenericData().put(PlatformDataKeys.COMPOSITE_DIFF_VIEWER.getName(), panel);
        final List layers = request.getOtherLayers();
        if (layers != null) {
            for (Pair layer : layers) {
                ((DiffRequest)layer.getSecond()).getGenericData().put(PlatformDataKeys.COMPOSITE_DIFF_VIEWER.getName(), panel);
            }
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                String name = PlatformDataKeys.COMPOSITE_DIFF_VIEWER.getName();
                request.getGenericData().remove(name);
                if (layers != null) {
                    for (Pair layer : layers) {
                        ((DiffRequest)layer.getSecond()).getGenericData().remove(name);
                    }
                }
            }
        });
        return panel;
    }

    @Override
    public DiffViewer viewerForRequest(Window window, @NotNull Disposable parentDisposable, String name, DiffRequest current) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool", "viewerForRequest"));
        }
        DiffViewer viewer = null;
        for (DiffTool tool : this.myTools) {
            if (tool.canShow(current) && (viewer = tool.createComponent(name, current, window, parentDisposable)) != null) break;
        }
        return viewer;
    }

    @Override
    public Map<String, DiffRequest> discloseRequest(DiffRequest request) {
        TreeMap<String, DiffRequest> pairs = new TreeMap<String, DiffRequest>((o1, o2) -> {
            if (ourDefaultTab.equals(o1)) {
                return -1;
            }
            if (ourDefaultTab.equals(o2)) {
                return 1;
            }
            return Comparing.compare((Comparable)((Object)o1), (Comparable)((Object)o2));
        });
        List layers = request.getOtherLayers();
        for (Pair layer : layers) {
            pairs.put((String)layer.getFirst(), (DiffRequest)layer.getSecond());
        }
        pairs.put(ourDefaultTab, request);
        return pairs;
    }

    public boolean canShow(DiffRequest request) {
        return MultiLevelDiffTool.canShowRequest(request);
    }

    public static boolean canShowRequest(DiffRequest request) {
        boolean isFile = false;
        DiffContent[] contents = request.getContents();
        for (int i = 0; i < contents.length; ++i) {
            DiffContent content = contents[i];
            VirtualFile file2 = content.getFile();
            if (file2 == null || !file2.isInLocalFileSystem() || file2.isDirectory()) continue;
            isFile = true;
            break;
        }
        AbstractProperty.AbstractPropertyContainer config = DiffManagerImpl.getInstanceEx().getProperties();
        if (isFile && DiffManagerImpl.ENABLE_FILES.value(config)) {
            return false;
        }
        if (!isFile && DiffManagerImpl.ENABLE_FOLDERS.value(config)) {
            return false;
        }
        return !DiffViewerType.merge.equals((Object)request.getType()) || !MultiLevelDiffTool.contentsWriteable(request);
    }

    private static boolean contentsWriteable(DiffRequest request) {
        DiffContent[] contents;
        for (DiffContent content : contents = request.getContents()) {
            if (content == null || !content.getDocument().isWritable()) continue;
            return true;
        }
        return false;
    }

    public DiffViewer createComponent(String title, DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool", "createComponent"));
        }
        throw new IllegalStateException();
    }
}

