/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.EditorPlace;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.containers.HashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;

public class FontSizeSynchronizer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.FontSizeSynchronizer");
    private final Collection<Editor> myEditors = new HashSet();
    private final MyFontSizeListener myFontSizeListener = new MyFontSizeListener();
    private int myLastFontSize = -1;

    public void synchronize(EditorEx editor) {
        LOG.assertTrue(!this.myEditors.contains(editor));
        editor.addPropertyChangeListener(this.myFontSizeListener);
        this.myEditors.add(editor);
        if (this.myLastFontSize != -1) {
            this.myFontSizeListener.updateEditor(editor);
        }
    }

    public void stopSynchronize(EditorEx editor) {
        LOG.assertTrue(this.myEditors.contains(editor));
        editor.removePropertyChangeListener(this.myFontSizeListener);
        this.myEditors.remove(editor);
    }

    public static void attachTo(ArrayList<EditorPlace> editorPlaces) {
        final FontSizeSynchronizer synchronizer = new FontSizeSynchronizer();
        for (EditorPlace editorPlace : editorPlaces) {
            editorPlace.addListener(new EditorPlace.EditorListener(){

                @Override
                public void onEditorCreated(EditorPlace place) {
                    synchronizer.synchronize((EditorEx)place.getEditor());
                }

                @Override
                public void onEditorReleased(Editor releasedEditor) {
                    synchronizer.stopSynchronize((EditorEx)releasedEditor);
                }
            });
            EditorEx editor = (EditorEx)editorPlace.getEditor();
            if (editor == null) continue;
            synchronizer.synchronize(editor);
        }
    }

    private class MyFontSizeListener
    implements PropertyChangeListener {
        private boolean myDuringUpdate = false;

        private MyFontSizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            FontSizeSynchronizer.this.myLastFontSize = (Integer)evt.getNewValue();
            for (Editor editor : FontSizeSynchronizer.this.myEditors) {
                if (editor == null || editor == evt.getSource()) continue;
                this.updateEditor((EditorEx)editor);
            }
        }

        public void updateEditor(EditorEx editor) {
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(FontSizeSynchronizer.this.myLastFontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }
    }
}

