/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipCommaIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/FlipCommaIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Flip ','" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/FlipCommaIntention", "getFamilyName"));
        }
        return "Flip ','";
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/actions/FlipCommaIntention", "isAvailable"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "isAvailable"));
        }
        PsiElement comma = FlipCommaIntention.currentCommaElement(editor, file2);
        return comma != null && FlipCommaIntention.smartAdvance(comma, true) != null && FlipCommaIntention.smartAdvance(comma, false) != null;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/actions/FlipCommaIntention", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "invoke"));
        }
        PsiElement element = FlipCommaIntention.currentCommaElement(editor, file2);
        if (element != null) {
            FlipCommaIntention.swapAtComma(element);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void swapAtComma(@NotNull PsiElement comma) {
        if (comma == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comma", "com/intellij/openapi/editor/actions/FlipCommaIntention", "swapAtComma"));
        }
        PsiElement prev = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement next = FlipCommaIntention.smartAdvance(comma, true);
        if (prev != null && next != null) {
            if (Flipper.tryFlip(prev, next)) {
                return;
            }
            PsiElement copy = prev.copy();
            prev.replace(next);
            next.replace(copy);
        }
    }

    private static PsiElement currentCommaElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "currentCommaElement"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "currentCommaElement"));
        }
        PsiElement element = FlipCommaIntention.leftElement(editor, file2);
        if (!FlipCommaIntention.isComma(element) && !FlipCommaIntention.isComma(element = FlipCommaIntention.rightElement(editor, file2))) {
            return null;
        }
        return element;
    }

    @Nullable
    private static PsiElement leftElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "leftElement"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "leftElement"));
        }
        return file2.findElementAt(editor.getCaretModel().getOffset() - 1);
    }

    @Nullable
    private static PsiElement rightElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "rightElement"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "rightElement"));
        }
        return file2.findElementAt(editor.getCaretModel().getOffset());
    }

    private static boolean isComma(@Nullable PsiElement element) {
        return element != null && element.getText().equals(",");
    }

    @NotNull
    private static JBIterable<PsiElement> getSiblings(PsiElement element, boolean fwd) {
        SyntaxTraverser.ApiEx api = fwd ? SyntaxTraverser.psiApi() : SyntaxTraverser.psiApiReversed();
        JBIterable flatSiblings = JBIterable.generate((Object)element, arg_0 -> ((SyntaxTraverser.ApiEx)api).next(arg_0)).skip(1);
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser((SyntaxTraverser.Api)api).withRoots((Iterable)flatSiblings)).expandAndSkip(e -> api.typeOf(e) == GeneratedParserUtilBase.DUMMY_BLOCK)).traverse();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/FlipCommaIntention", "getSiblings"));
        }
        return jBIterable;
    }

    private static boolean isFlippable(PsiElement e) {
        if (e instanceof PsiWhiteSpace || e instanceof PsiComment) {
            return false;
        }
        return StringUtil.isNotEmpty((String)e.getText());
    }

    @Nullable
    private static PsiElement smartAdvance(PsiElement element, boolean fwd) {
        return (PsiElement)FlipCommaIntention.getSiblings(element, fwd).filter(e -> FlipCommaIntention.isFlippable(e)).first();
    }

    public static interface Flipper {
        public static final LanguageExtension<Flipper> EXTENSION = new LanguageExtension("com.intellij.flipCommaIntention.flipper");

        public boolean flip(PsiElement var1, PsiElement var2);

        public static boolean tryFlip(PsiElement left, PsiElement right) {
            Language language = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language)) {
                if (!handler2.flip(left, right)) continue;
                return true;
            }
            return false;
        }
    }
}

