/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.ShortcutFilteringPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class ChooseActionsDialog
extends DialogWrapper {
    private final ActionsTree myActionsTree;
    private FilterComponent myFilterComponent;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private final ShortcutFilteringPanel myFilteringPanel = new ShortcutFilteringPanel();
    private Keymap myKeymap;
    private QuickList[] myQuicklists;

    public ChooseActionsDialog(Component parent, Keymap keymap, QuickList[] quicklists) {
        super(parent, true);
        this.myKeymap = keymap;
        this.myQuicklists = quicklists;
        this.myActionsTree = new ActionsTree();
        this.myActionsTree.reset(keymap, quicklists);
        this.myActionsTree.getTree().getSelectionModel().setSelectionMode(4);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                ChooseActionsDialog.this.doOKAction();
                return true;
            }
        }.installOn((Component)this.myActionsTree.getTree());
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        this.myFilteringPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ChooseActionsDialog.this.filterTreeByShortcut(ChooseActionsDialog.this.myFilteringPanel.getShortcut());
            }
        });
        this.setTitle("Add Actions to Quick List");
        this.init();
    }

    protected JComponent createNorthPanel() {
        return this.createToolbarPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myFilterComponent.getTextEditor();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.myActionsTree.getComponent());
        panel.setPreferredSize((Dimension)JBUI.size((int)400, (int)500));
        return panel;
    }

    public String[] getTreeSelectedActionIds() {
        TreePath[] paths = this.myActionsTree.getTree().getSelectionPaths();
        if (paths == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> actions = new ArrayList<String>();
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            if (!(node instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode defNode = (DefaultMutableTreeNode)node;
            Object userObject = defNode.getUserObject();
            if (userObject instanceof String) {
                actions.add((String)userObject);
                continue;
            }
            if (!(userObject instanceof QuickList)) continue;
            actions.add(((QuickList)userObject).getActionId());
        }
        return ArrayUtil.toStringArray(actions);
    }

    private JPanel createToolbarPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)ChooseActionsDialog.this.myActionsTree.getTree());
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)ChooseActionsDialog.this.myActionsTree.getTree(), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        group.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        panel.add((Component)toolbar, "West");
        group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent searchToolbar = actionToolbar.getComponent();
        final Alarm alarm = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP_IN_QUICK_LISTS", 5){

            public void filter() {
                alarm.cancelAllRequests();
                alarm.addRequest(() -> {
                    if (!ChooseActionsDialog.this.myFilterComponent.isShowing()) {
                        return;
                    }
                    if (!ChooseActionsDialog.this.myTreeExpansionMonitor.isFreeze()) {
                        ChooseActionsDialog.this.myTreeExpansionMonitor.freeze();
                    }
                    ChooseActionsDialog.this.myFilteringPanel.setShortcut(null);
                    String filter = this.getFilter();
                    ChooseActionsDialog.this.myActionsTree.filter(filter, ChooseActionsDialog.this.myQuicklists);
                    JTree tree = ChooseActionsDialog.this.myActionsTree.getTree();
                    TreeUtil.expandAll((JTree)tree);
                    if (filter == null || filter.length() == 0) {
                        TreeUtil.collapseAll((JTree)tree, (int)0);
                        ChooseActionsDialog.this.myTreeExpansionMonitor.restore();
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel.add((Component)this.myFilterComponent, "Center");
        group.add(new AnAction(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), AllIcons.Actions.ShortcutFilter){

            public void actionPerformed(AnActionEvent e) {
                ChooseActionsDialog.this.myFilterComponent.reset();
                ChooseActionsDialog.this.myActionsTree.reset(ChooseActionsDialog.this.myKeymap, ChooseActionsDialog.this.myQuicklists);
                ChooseActionsDialog.this.myFilteringPanel.showPopup(searchToolbar);
            }
        });
        group.add(new AnAction(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), AllIcons.Actions.GC){

            public void update(AnActionEvent event) {
                boolean enabled = null != ChooseActionsDialog.this.myFilteringPanel.getShortcut();
                Presentation presentation = event.getPresentation();
                presentation.setEnabled(enabled);
                presentation.setIcon(enabled ? AllIcons.Actions.Cancel : EmptyIcon.ICON_16);
            }

            public void actionPerformed(AnActionEvent e) {
                ChooseActionsDialog.this.myFilteringPanel.setShortcut(null);
                ChooseActionsDialog.this.myActionsTree.filter(null, ChooseActionsDialog.this.myQuicklists);
                TreeUtil.collapseAll((JTree)ChooseActionsDialog.this.myActionsTree.getTree(), (int)0);
                ChooseActionsDialog.this.myTreeExpansionMonitor.restore();
            }
        });
        panel.add((Component)searchToolbar, "East");
        return panel;
    }

    private void filterTreeByShortcut(Shortcut shortcut) {
        if (!this.myTreeExpansionMonitor.isFreeze()) {
            this.myTreeExpansionMonitor.freeze();
        }
        this.myActionsTree.reset(this.myKeymap, this.myQuicklists);
        this.myActionsTree.filterTree(shortcut, this.myQuicklists);
        JTree tree = this.myActionsTree.getTree();
        TreeUtil.expandAll((JTree)tree);
    }

    public void dispose() {
        super.dispose();
        this.myFilteringPanel.hidePopup();
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
    }
}

