/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.ContentFolderBaseImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;

public class SourceFolderImpl
extends ContentFolderBaseImpl
implements SourceFolder,
ClonableContentFolder {
    private JpsModuleSourceRoot myJpsElement;
    @NonNls
    public static final String ELEMENT_NAME = "sourceFolder";
    @NonNls
    public static final String TEST_SOURCE_ATTR = "isTestSource";
    static final String DEFAULT_PACKAGE_PREFIX = "";

    SourceFolderImpl(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRoot jpsElement, @NotNull ContentEntryImpl contentEntry) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/SourceFolderImpl", "<init>"));
        }
        if (jpsElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jpsElement", "com/intellij/openapi/roots/impl/SourceFolderImpl", "<init>"));
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/intellij/openapi/roots/impl/SourceFolderImpl", "<init>"));
        }
        super(file2, contentEntry);
        this.myJpsElement = jpsElement;
    }

    public SourceFolderImpl(@NotNull JpsModuleSourceRoot jpsElement, @NotNull ContentEntryImpl contentEntry) {
        if (jpsElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jpsElement", "com/intellij/openapi/roots/impl/SourceFolderImpl", "<init>"));
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/intellij/openapi/roots/impl/SourceFolderImpl", "<init>"));
        }
        super(jpsElement.getUrl(), contentEntry);
        this.myJpsElement = jpsElement;
    }

    SourceFolderImpl(Element element, ContentEntryImpl contentEntry) throws InvalidDataException {
        super(element, contentEntry);
        this.myJpsElement = JpsModuleRootModelSerializer.loadSourceRoot((Element)element);
    }

    private SourceFolderImpl(SourceFolderImpl that, ContentEntryImpl contentEntry) {
        super(that, contentEntry);
        this.myJpsElement = SourceFolderImpl.createCopy(that, that.myJpsElement.asTyped());
    }

    private static <P extends JpsElement> JpsModuleSourceRoot createCopy(SourceFolderImpl that, JpsTypedModuleSourceRoot<P> jpsElement) {
        return JpsElementFactory.getInstance().createModuleSourceRoot(that.getUrl(), jpsElement.getRootType(), jpsElement.getProperties().getBulkModificationSupport().createCopy());
    }

    public boolean isTestSource() {
        return this.getRootType().equals((Object)JavaSourceRootType.TEST_SOURCE) || this.getRootType().equals((Object)JavaResourceRootType.TEST_RESOURCE);
    }

    @NotNull
    public String getPackagePrefix() {
        JavaSourceRootProperties properties = this.getJavaProperties();
        if (properties != null) {
            String string = properties.getPackagePrefix();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/SourceFolderImpl", "getPackagePrefix"));
            }
            return string;
        }
        JavaResourceRootProperties resourceJavaProperties = this.getResourceJavaProperties();
        if (resourceJavaProperties != null) {
            String string = resourceJavaProperties.getRelativeOutputPath().replace('/', '.');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/SourceFolderImpl", "getPackagePrefix"));
            }
            return string;
        }
        if (DEFAULT_PACKAGE_PREFIX == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/SourceFolderImpl", "getPackagePrefix"));
        }
        return DEFAULT_PACKAGE_PREFIX;
    }

    @Nullable
    private JavaSourceRootProperties getJavaProperties() {
        return (JavaSourceRootProperties)this.myJpsElement.getProperties(JavaModuleSourceRootTypes.SOURCES);
    }

    @Nullable
    private JavaResourceRootProperties getResourceJavaProperties() {
        return (JavaResourceRootProperties)this.myJpsElement.getProperties(JavaModuleSourceRootTypes.RESOURCES);
    }

    public void setPackagePrefix(@NotNull String packagePrefix) {
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/intellij/openapi/roots/impl/SourceFolderImpl", "setPackagePrefix"));
        }
        JavaSourceRootProperties properties = this.getJavaProperties();
        if (properties != null) {
            properties.setPackagePrefix(packagePrefix);
        }
    }

    @NotNull
    public JpsModuleSourceRootType<?> getRootType() {
        JpsModuleSourceRootType jpsModuleSourceRootType = this.myJpsElement.getRootType();
        if (jpsModuleSourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/SourceFolderImpl", "getRootType"));
        }
        return jpsModuleSourceRootType;
    }

    @Override
    public ContentFolder cloneFolder(ContentEntry contentEntry) {
        assert (!((ContentEntryImpl)contentEntry).isDisposed()) : "target entry already disposed: " + contentEntry;
        assert (!this.isDisposed()) : "Already disposed: " + this;
        return new SourceFolderImpl(this, (ContentEntryImpl)contentEntry);
    }

    @NotNull
    public JpsModuleSourceRoot getJpsElement() {
        JpsModuleSourceRoot jpsModuleSourceRoot = this.myJpsElement;
        if (jpsModuleSourceRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/SourceFolderImpl", "getJpsElement"));
        }
        return jpsModuleSourceRoot;
    }

    private boolean isForGeneratedSources() {
        JavaSourceRootProperties properties = this.getJavaProperties();
        JavaResourceRootProperties resourceJavaProperties = this.getResourceJavaProperties();
        return properties != null && properties.isForGeneratedSources() || resourceJavaProperties != null && resourceJavaProperties.isForGeneratedSources();
    }

    @Override
    public int compareTo(ContentFolderBaseImpl folder) {
        if (!(folder instanceof SourceFolderImpl)) {
            return -1;
        }
        int i = super.compareTo(folder);
        if (i != 0) {
            return i;
        }
        SourceFolderImpl sourceFolder = (SourceFolderImpl)folder;
        i = this.getPackagePrefix().compareTo(sourceFolder.getPackagePrefix());
        if (i != 0) {
            return i;
        }
        i = Boolean.valueOf(this.isTestSource()).compareTo(sourceFolder.isTestSource());
        if (i != 0) {
            return i;
        }
        i = Boolean.valueOf(this.isForGeneratedSources()).compareTo(sourceFolder.isForGeneratedSources());
        if (i != 0) {
            return i;
        }
        return this.myJpsElement.getRootType().getClass().getName().compareTo(sourceFolder.getRootType().getClass().getName());
    }
}

