/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AlienChangeListBrowser
extends ChangesBrowser {
    private final List<Change> myChanges;
    private final AbstractVcs myVcs;

    public AlienChangeListBrowser(Project project2, List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection, boolean capableOfExcludingChanges, boolean highlightProblems, AbstractVcs vcs) {
        super(project2, changeLists, changes, initialListSelection, capableOfExcludingChanges, highlightProblems, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myChanges = changes;
        this.myVcs = vcs;
        this.rebuildList();
    }

    @Override
    public void rebuildList() {
        this.myViewer.setChangesToDisplay(this.myChanges == null ? Collections.emptyList() : this.myChanges);
    }

    @Override
    protected void setInitialSelection(List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection) {
        if (!changeLists.isEmpty()) {
            this.mySelectedChangeList = changeLists.get(0);
        }
    }

    @Override
    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        super.buildToolBar(toolBarGroup);
        toolBarGroup.add(ActionManager.getInstance().getAction("AlienCommitChangesDialog.AdditionalActions"));
    }

    @Override
    @NotNull
    public Set<AbstractVcs> getAffectedVcses() {
        Set set = ContainerUtil.immutableSet((Object[])new AbstractVcs[]{this.myVcs});
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/AlienChangeListBrowser", "getAffectedVcses"));
        }
        return set;
    }

    @Override
    @NotNull
    public List<Change> getCurrentIncludedChanges() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myChanges);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/AlienChangeListBrowser", "getCurrentIncludedChanges"));
        }
        return arrayList;
    }
}

