/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CodeSmellDetectorImpl
extends CodeSmellDetector {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.CodeSmellDetectorImpl");

    public CodeSmellDetectorImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void showCodeSmellErrors(final @NotNull List<CodeSmellInfo> smellList) {
        if (smellList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smellList", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "showCodeSmellErrors"));
        }
        Collections.sort(smellList, new Comparator<CodeSmellInfo>(){

            @Override
            public int compare(CodeSmellInfo o1, CodeSmellInfo o2) {
                return o1.getTextRange().getStartOffset() - o2.getTextRange().getStartOffset();
            }
        });
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CodeSmellDetectorImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (smellList.isEmpty()) {
                    return;
                }
                VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(CodeSmellDetectorImpl.this.myProject);
                AbstractVcsHelperImpl helper = (AbstractVcsHelperImpl)AbstractVcsHelper.getInstance((Project)CodeSmellDetectorImpl.this.myProject);
                helper.openMessagesView(errorTreeView, VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]));
                FileDocumentManager fileManager = FileDocumentManager.getInstance();
                for (CodeSmellInfo smellInfo : smellList) {
                    VirtualFile file2 = fileManager.getFile(smellInfo.getDocument());
                    OpenFileDescriptor navigatable = new OpenFileDescriptor(CodeSmellDetectorImpl.this.myProject, file2, smellInfo.getStartLine(), smellInfo.getStartColumn());
                    String exportPrefix = NewErrorTreeViewPanel.createExportPrefix(smellInfo.getStartLine() + 1);
                    String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix(smellInfo.getStartLine() + 1, smellInfo.getStartColumn() + 1);
                    if (smellInfo.getSeverity() == HighlightSeverity.ERROR) {
                        errorTreeView.addMessage(4, new String[]{smellInfo.getDescription()}, file2.getPresentableUrl(), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
                        continue;
                    }
                    errorTreeView.addMessage(5, new String[]{smellInfo.getDescription()}, file2.getPresentableUrl(), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
                }
            }
        });
    }

    @Override
    @NotNull
    public List<CodeSmellInfo> findCodeSmells(final @NotNull List<VirtualFile> filesToCheck) throws ProcessCanceledException {
        if (filesToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToCheck", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final ArrayList<CodeSmellInfo> result2 = new ArrayList<CodeSmellInfo>();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new RuntimeException("Must not run under write action");
        }
        final Ref exception = Ref.create();
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, VcsBundle.message((String)"checking.code.smells.progress.title", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator progress) {
                if (progress == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl$3", "run"));
                }
                try {
                    for (int i = 0; i < filesToCheck.size(); ++i) {
                        if (progress.isCanceled()) {
                            throw new ProcessCanceledException();
                        }
                        VirtualFile file2 = (VirtualFile)filesToCheck.get(i);
                        progress.setText(VcsBundle.message((String)"searching.for.code.smells.processing.file.progress.text", (Object[])new Object[]{file2.getPresentableUrl()}));
                        progress.setFraction((double)i / (double)filesToCheck.size());
                        result2.addAll(CodeSmellDetectorImpl.this.findCodeSmells(file2, progress));
                    }
                }
                catch (ProcessCanceledException e) {
                    exception.set((Object)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    exception.set((Object)e);
                }
            }
        });
        if (!exception.isNull()) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)((Throwable)exception.get()));
        }
        ArrayList<CodeSmellInfo> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        return arrayList;
    }

    @NotNull
    private List<CodeSmellInfo> findCodeSmells(final @NotNull VirtualFile file2, @NotNull ProgressIndicator progress) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        final List<CodeSmellInfo> result2 = Collections.synchronizedList(new ArrayList());
        final DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        final DaemonProgressIndicator daemonIndicator = new DaemonProgressIndicator();
        ((ProgressIndicatorEx)progress).addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                daemonIndicator.cancel();
            }
        });
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)CodeSmellDetectorImpl.this.myProject).runReadActionInSmartMode(new Runnable(){

                    @Override
                    public void run() {
                        PsiFile psiFile = PsiManager.getInstance((Project)CodeSmellDetectorImpl.this.myProject).findFile(file2);
                        Document document2 = FileDocumentManager.getInstance().getDocument(file2);
                        if (psiFile == null || document2 == null) {
                            return;
                        }
                        List<HighlightInfo> infos = codeAnalyzer.runMainPasses(psiFile, document2, daemonIndicator);
                        CodeSmellDetectorImpl.this.convertErrorsAndWarnings(infos, result2, document2);
                    }
                });
            }
        }, (ProgressIndicator)daemonIndicator);
        List<CodeSmellInfo> list = result2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        return list;
    }

    private void convertErrorsAndWarnings(@NotNull Collection<HighlightInfo> highlights, @NotNull List<CodeSmellInfo> result2, @NotNull Document document2) {
        if (highlights == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlights", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "convertErrorsAndWarnings"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "convertErrorsAndWarnings"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "convertErrorsAndWarnings"));
        }
        for (HighlightInfo highlightInfo : highlights) {
            HighlightSeverity severity = highlightInfo.getSeverity();
            if (SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(severity, HighlightSeverity.WARNING) < 0) continue;
            result2.add(new CodeSmellInfo(document2, CodeSmellDetectorImpl.getDescription(highlightInfo), new TextRange(highlightInfo.startOffset, highlightInfo.endOffset), severity));
        }
    }

    private static String getDescription(@NotNull HighlightInfo highlightInfo) {
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "getDescription"));
        }
        String description = highlightInfo.getDescription();
        HighlightInfoType type = highlightInfo.type;
        if (type instanceof HighlightInfoType.HighlightInfoTypeSeverityByKey) {
            HighlightDisplayKey severityKey = ((HighlightInfoType.HighlightInfoTypeSeverityByKey)type).getSeverityKey();
            String id = severityKey.getID();
            return "[" + id + "] " + description;
        }
        return description;
    }
}

