/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import java.util.Comparator;

public class InspectionsConfigTreeComparator
implements Comparator<InspectionConfigTreeNode> {
    @Override
    public int compare(InspectionConfigTreeNode o1, InspectionConfigTreeNode o2) {
        String s1 = null;
        String s2 = null;
        Object userObject1 = o1.getUserObject();
        Object userObject2 = o2.getUserObject();
        if (userObject1 instanceof String && userObject2 instanceof String) {
            s1 = (String)userObject1;
            s2 = (String)userObject2;
        } else {
            if (userObject1 instanceof String) {
                return -1;
            }
            if (userObject2 instanceof String) {
                return 1;
            }
        }
        if (s1 != null) {
            return InspectionsConfigTreeComparator.getDisplayTextToSort(s1).compareToIgnoreCase(InspectionsConfigTreeComparator.getDisplayTextToSort(s2));
        }
        ToolDescriptors descriptors1 = o1.getDescriptors();
        ToolDescriptors descriptors2 = o2.getDescriptors();
        if (descriptors1 != null && descriptors2 != null) {
            s1 = descriptors1.getDefaultDescriptor().getText();
            s2 = descriptors2.getDefaultDescriptor().getText();
        }
        if (s1 != null && s2 != null) {
            return InspectionsConfigTreeComparator.getDisplayTextToSort(s1).compareToIgnoreCase(InspectionsConfigTreeComparator.getDisplayTextToSort(s2));
        }
        return -1;
    }

    public static String getDisplayTextToSort(String s) {
        if (s.length() == 0) {
            return s;
        }
        while (!Character.isLetterOrDigit(s.charAt(0))) {
            if ((s = s.substring(1)).length() != 0) continue;
            return s;
        }
        return s;
    }
}

