/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiGraphInferenceHelper
implements PsiInferenceHelper {
    private final PsiManager myManager;

    public PsiGraphInferenceHelper(PsiManager manager) {
        this.myManager = manager;
    }

    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        PsiSubstitutor substitutor;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (parent != null) {
            substitutor = this.inferTypeArguments(new PsiTypeParameter[]{typeParameter}, parameters, arguments, partialSubstitutor, parent, policy, PsiUtil.getLanguageLevel((PsiElement)parent));
        } else {
            InferenceSession inferenceSession = new InferenceSession(new PsiTypeParameter[]{typeParameter}, partialSubstitutor, this.myManager, null);
            inferenceSession.initExpressionConstraints(parameters, arguments, null, null);
            substitutor = inferenceSession.infer();
        }
        return substitutor.substitute(typeParameter);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (typeParameters.length == 0) {
            PsiSubstitutor psiSubstitutor = partialSubstitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = InferenceSessionContainer.infer(typeParameters, parameters, arguments, partialSubstitutor, parent, policy);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftTypes", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightTypes", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (typeParameters.length == 0) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        InferenceSession session2 = new InferenceSession(typeParameters, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        for (PsiType leftType : leftTypes) {
            if (session2.isProperType(session2.substituteWithInferenceVariables(leftType))) continue;
            PsiSubstitutor psiSubstitutor = session2.infer();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        for (PsiType rightType : rightTypes) {
            if (session2.isProperType(session2.substituteWithInferenceVariables(rightType))) continue;
            PsiSubstitutor psiSubstitutor = session2.infer();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiTypeParameter[] psiTypeParameterArray;
        PsiType[] rightTypes;
        PsiType[] leftTypes;
        if (PsiType.VOID.equals((Object)arg) || PsiType.VOID.equals((Object)param)) {
            return PsiType.NULL;
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameter(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return PsiType.NULL;
        }
        if (arg == null) {
            return PsiType.NULL;
        }
        if (isContraVariantPosition) {
            leftTypes = new PsiType[]{param};
            rightTypes = new PsiType[]{arg};
        } else {
            leftTypes = new PsiType[]{arg};
            rightTypes = new PsiType[]{param};
        }
        PsiTypeParameterListOwner owner = typeParam.getOwner();
        if (owner != null) {
            psiTypeParameterArray = owner.getTypeParameters();
        } else {
            PsiTypeParameter[] psiTypeParameterArray2 = new PsiTypeParameter[1];
            psiTypeParameterArray = psiTypeParameterArray2;
            psiTypeParameterArray2[0] = typeParam;
        }
        PsiTypeParameter[] typeParams = psiTypeParameterArray;
        InferenceSession inferenceSession = new InferenceSession(typeParams, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(param)) && inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(arg))) {
            boolean proceed = false;
            for (PsiClassType classType : typeParam.getExtendsListTypes()) {
                if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables((PsiType)classType))) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                return PsiType.NULL;
            }
        }
        PsiSubstitutor substitutor = inferenceSession.infer();
        return substitutor.substitute(typeParam);
    }
}

