/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Location;
import com.intellij.execution.TestStateStorage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Ref;
import com.intellij.testIntegration.TestLocator;
import java.util.Collection;

public class DeadTestsCleaner
implements Runnable {
    private final TestStateStorage myTestStorage;
    private final Collection<String> myTestUrls;
    private final TestLocator myTestLocator;

    public DeadTestsCleaner(TestStateStorage storage2, Collection<String> urls, TestLocator locator) {
        this.myTestStorage = storage2;
        this.myTestUrls = urls;
        this.myTestLocator = locator;
    }

    @Override
    public void run() {
        for (String url : this.myTestUrls) {
            this.processUrl(url);
        }
    }

    private void processUrl(String url) {
        Ref locationRef = Ref.create();
        ApplicationManager.getApplication().runReadAction(() -> {
            Location location = this.myTestLocator.getLocation(url);
            locationRef.set((Object)location);
        });
        if (locationRef.get() == null) {
            this.myTestStorage.removeState(url);
        }
    }
}

