/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.TestStateStorage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.testIntegration.DeadTestsCleaner;
import com.intellij.testIntegration.RecentTestRunnerImpl;
import com.intellij.testIntegration.RecentTestsListPopup;
import com.intellij.testIntegration.RecentTestsListProvider;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationByRecordProvider;
import com.intellij.testIntegration.SelectTestStep;
import com.intellij.testIntegration.TestLocator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ShowRecentTests
extends AnAction {
    private static final int TEST_LIMIT = Integer.MAX_VALUE;

    private static Date getSinceDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/testIntegration/ShowRecentTests", "update"));
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        TestStateStorage testStorage = TestStateStorage.getInstance(project2);
        TestLocator testLocator = new TestLocator(project2);
        RecentTestRunnerImpl testRunner = new RecentTestRunnerImpl(project2, testLocator);
        Map<String, TestStateStorage.Record> records = testStorage.getRecentTests(Integer.MAX_VALUE, ShowRecentTests.getSinceDate());
        RunConfigurationByRecordProvider configurationProvider = new RunConfigurationByRecordProvider(project2);
        RecentTestsListProvider listProvider = new RecentTestsListProvider(configurationProvider, records);
        List<RecentTestsPopupEntry> entries = listProvider.getTestsToShow();
        SelectTestStep selectStepTest = new SelectTestStep(entries, testRunner);
        RecentTestsListPopup popup = new RecentTestsListPopup((ListPopupStep<RecentTestsPopupEntry>)selectStepTest, testRunner, testLocator);
        popup.showCenteredInCurrentWindow(project2);
        ShowRecentTests.cleanDeadTests(entries, testLocator, testStorage);
    }

    private static void cleanDeadTests(List<RecentTestsPopupEntry> entries, TestLocator testLocator, TestStateStorage testStorage) {
        ArrayList urls = ContainerUtil.newArrayList();
        entries.forEach(entry -> urls.addAll(entry.getTestsUrls()));
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new DeadTestsCleaner(testStorage, urls, testLocator));
    }
}

