/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.GeneralRunner;
import com.intellij.util.continuation.ModalityIgnorantBackgroundableTask;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class SeparatePiecesRunner
extends GeneralRunner {
    private final AtomicReference<TaskWrapper> myCurrentWrapper = new AtomicReference();

    public SeparatePiecesRunner(Project project2, boolean cancellable) {
        super(project2, cancellable);
    }

    @Override
    public void ping() {
        this.clearSuspend();
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    SeparatePiecesRunner.this.pingImpl();
                }
            };
            SwingUtilities.invokeLater(command);
        } else {
            this.pingImpl();
        }
    }

    private void pingImpl() {
        TaskDescriptor current;
        while (true) {
            this.myCurrentWrapper.set(null);
            if (!this.myProject.isDefault() && !this.myProject.isOpen()) {
                return;
            }
            if (this.getSuspendFlag()) {
                return;
            }
            current = this.getNextMatching();
            if (current == null) {
                return;
            }
            if (!Where.AWT.equals((Object)current.getWhere())) break;
            this.setIndicator(null);
            try {
                current.run((ContinuationContext)this);
            }
            catch (RuntimeException th) {
                this.handleException(th, true);
            }
        }
        TaskWrapper task = new TaskWrapper(this.myProject, current.getName(), this.myCancellable, current);
        this.myCurrentWrapper.set(task);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.setIndicator((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            this.setIndicator(new BackgroundableProcessIndicator(task));
        }
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, this.getIndicator());
    }

    @Override
    public void suspend() {
        super.suspend();
        TaskWrapper wrapper = this.myCurrentWrapper.get();
        if (wrapper != null) {
            wrapper.mySuspended = true;
        }
    }

    class TaskWrapper
    extends ModalityIgnorantBackgroundableTask {
        private final TaskDescriptor myTaskDescriptor;
        private volatile boolean mySuspended;

        TaskWrapper(@NotNull Project project2, String title, boolean canBeCancelled, TaskDescriptor taskDescriptor) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/continuation/SeparatePiecesRunner$TaskWrapper", "<init>"));
            }
            super(project2, title, canBeCancelled);
            this.myTaskDescriptor = taskDescriptor;
            this.mySuspended = false;
        }

        @Override
        protected void doInAwtIfFail(Exception e) {
            this.doInAwtIfCancel();
        }

        @Override
        protected void doInAwtIfCancel() {
            this.onCancel();
        }

        @Override
        protected void doInAwtIfSuccess() {
            if (!this.mySuspended) {
                SeparatePiecesRunner.this.ping();
            }
        }

        @Override
        protected void runImpl(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/continuation/SeparatePiecesRunner$TaskWrapper", "runImpl"));
            }
            this.myTaskDescriptor.run((ContinuationContext)SeparatePiecesRunner.this);
        }
    }
}

