/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class VcsLogUiPropertiesImpl
implements PersistentStateComponent<State>,
VcsLogUiProperties {
    private static final int RECENTLY_FILTERED_VALUES_LIMIT = 10;

    @NotNull
    public abstract State getState();

    @Override
    public boolean isShowDetails() {
        return this.getState().SHOW_DETAILS;
    }

    @Override
    public void setShowDetails(boolean showDetails) {
        this.getState().SHOW_DETAILS = showDetails;
    }

    @Override
    public void addRecentlyFilteredUserGroup(@NotNull List<String> usersInGroup) {
        if (usersInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usersInGroup", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "addRecentlyFilteredUserGroup"));
        }
        VcsLogUiPropertiesImpl.addRecentGroup(usersInGroup, this.getState().RECENTLY_FILTERED_USER_GROUPS);
    }

    @Override
    public void addRecentlyFilteredBranchGroup(@NotNull List<String> valuesInGroup) {
        if (valuesInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesInGroup", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "addRecentlyFilteredBranchGroup"));
        }
        VcsLogUiPropertiesImpl.addRecentGroup(valuesInGroup, this.getState().RECENTLY_FILTERED_BRANCH_GROUPS);
    }

    private static void addRecentGroup(@NotNull List<String> valuesInGroup, @NotNull Deque<UserGroup> stateField) {
        if (valuesInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesInGroup", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "addRecentGroup"));
        }
        if (stateField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateField", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "addRecentGroup"));
        }
        UserGroup group = new UserGroup();
        group.users = valuesInGroup;
        if (stateField.contains(group)) {
            return;
        }
        stateField.addFirst(group);
        if (stateField.size() > 10) {
            stateField.removeLast();
        }
    }

    @Override
    @NotNull
    public List<List<String>> getRecentlyFilteredUserGroups() {
        List<List<String>> list = VcsLogUiPropertiesImpl.getRecentGroup(this.getState().RECENTLY_FILTERED_USER_GROUPS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "getRecentlyFilteredUserGroups"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<List<String>> getRecentlyFilteredBranchGroups() {
        List<List<String>> list = VcsLogUiPropertiesImpl.getRecentGroup(this.getState().RECENTLY_FILTERED_BRANCH_GROUPS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "getRecentlyFilteredBranchGroups"));
        }
        return list;
    }

    @NotNull
    private static List<List<String>> getRecentGroup(Deque<UserGroup> stateField) {
        List list = ContainerUtil.map2List(stateField, group -> group.users);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "getRecentGroup"));
        }
        return list;
    }

    @Override
    public boolean areLongEdgesVisible() {
        return this.getState().LONG_EDGES_VISIBLE;
    }

    @Override
    public void setLongEdgesVisibility(boolean visible) {
        this.getState().LONG_EDGES_VISIBLE = visible;
    }

    @Override
    public int getBekSortType() {
        return this.getState().BEK_SORT_TYPE;
    }

    @Override
    public void setBek(int bekSortType) {
        this.getState().BEK_SORT_TYPE = bekSortType;
    }

    @Override
    public boolean isShowRootNames() {
        return this.getState().SHOW_ROOT_NAMES;
    }

    @Override
    public void setShowRootNames(boolean isShowRootNames) {
        this.getState().SHOW_ROOT_NAMES = isShowRootNames;
    }

    @Override
    public boolean isHighlighterEnabled(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "isHighlighterEnabled"));
        }
        Boolean result2 = this.getState().HIGHLIGHTERS.get(id);
        return result2 != null ? result2 : true;
    }

    @Override
    public void enableHighlighter(@NotNull String id, boolean value) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/data/VcsLogUiPropertiesImpl", "enableHighlighter"));
        }
        this.getState().HIGHLIGHTERS.put(id, value);
    }

    @Override
    public boolean isShowBranchesPanel() {
        return this.getState().SHOW_BRANCHES_PANEL;
    }

    @Override
    public void setShowBranchesPanel(boolean show) {
        this.getState().SHOW_BRANCHES_PANEL = show;
    }

    public static class UserGroup {
        public List<String> users = new ArrayList<String>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserGroup group = (UserGroup)o;
            return this.users.equals(group.users);
        }

        public int hashCode() {
            return this.users.hashCode();
        }
    }

    public static class State {
        public boolean SHOW_DETAILS = true;
        public boolean SHOW_BRANCHES_PANEL = false;
        public boolean LONG_EDGES_VISIBLE = false;
        public int BEK_SORT_TYPE = 0;
        public boolean SHOW_ROOT_NAMES = false;
        public Deque<UserGroup> RECENTLY_FILTERED_USER_GROUPS = new ArrayDeque<UserGroup>();
        public Deque<UserGroup> RECENTLY_FILTERED_BRANCH_GROUPS = new ArrayDeque<UserGroup>();
        public Map<String, Boolean> HIGHLIGHTERS = ContainerUtil.newTreeMap();
    }
}

