/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.collapsing.DottedFilterEdgesGenerator;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteredController
extends CascadeController {
    @NotNull
    private final CollapsedGraph myCollapsedGraph;

    protected FilteredController(@NotNull CascadeController delegateLinearGraphController, @NotNull PermanentGraphInfo permanentGraphInfo, @NotNull Set<Integer> matchedIds) {
        if (delegateLinearGraphController == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateLinearGraphController", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "<init>"));
        }
        if (permanentGraphInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphInfo", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "<init>"));
        }
        if (matchedIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchedIds", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "<init>"));
        }
        super(delegateLinearGraphController, permanentGraphInfo);
        UnsignedBitSet initVisibility = new UnsignedBitSet();
        for (Integer matchedId : matchedIds) {
            initVisibility.set(matchedId, true);
        }
        this.myCollapsedGraph = CollapsedGraph.newInstance(delegateLinearGraphController.getCompiledGraph(), initVisibility);
        DottedFilterEdgesGenerator.update(this.myCollapsedGraph, 0, this.myCollapsedGraph.getDelegatedGraph().nodesCount() - 1);
    }

    @Override
    @NotNull
    public LinearGraphController.LinearGraphAnswer performLinearGraphAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "performLinearGraphAction"));
        }
        LinearGraphController.LinearGraphAnswer answer = this.performAction(action);
        if (answer != null) {
            LinearGraphController.LinearGraphAnswer linearGraphAnswer = answer;
            if (linearGraphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "performLinearGraphAction"));
            }
            return linearGraphAnswer;
        }
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = LinearGraphUtils.DEFAULT_GRAPH_ANSWER;
        if (linearGraphAnswer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "performLinearGraphAction"));
        }
        return linearGraphAnswer;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "convertToDelegate"));
        }
        return null;
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateAnswer", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "delegateGraphChanged"));
        }
        if (delegateAnswer == LinearGraphUtils.DEFAULT_GRAPH_ANSWER) {
            LinearGraphController.LinearGraphAnswer linearGraphAnswer = delegateAnswer;
            if (linearGraphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "delegateGraphChanged"));
            }
            return linearGraphAnswer;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "performAction"));
        }
        return null;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearGraph linearGraph = this.myCollapsedGraph.getCompiledGraph();
        if (linearGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/FilteredController", "getCompiledGraph"));
        }
        return linearGraph;
    }
}

