/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.MakePublicStaticFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitRuleInspection
extends BaseInspection {
    public static final String RULE_FQN = "org.junit.Rule";
    public static final String CLASS_RULE_FQN = "org.junit.ClassRule";
    public boolean REPORT_RULE_PROBLEMS = true;
    public boolean REPORT_CLASS_RULE_PROBLEMS = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit.rule.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnitRuleInspection", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Report @Rule problems", "REPORT_RULE_PROBLEMS");
        panel.addCheckbox("Report @ClassRule problems", "REPORT_CLASS_RULE_PROBLEMS");
        return panel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnitRuleInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return infos.length > 1 ? new MakePublicStaticFix((String)infos[1], infos[2].equals(CLASS_RULE_FQN)) : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitField(PsiField field) {
                boolean classRuleAnnotated;
                boolean ruleAnnotated = JUnitRuleInspection.this.REPORT_RULE_PROBLEMS && AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (String)JUnitRuleInspection.RULE_FQN, (boolean)false);
                boolean bl = classRuleAnnotated = JUnitRuleInspection.this.REPORT_CLASS_RULE_PROBLEMS && AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (String)JUnitRuleInspection.CLASS_RULE_FQN, (boolean)false);
                if (ruleAnnotated || classRuleAnnotated) {
                    PsiClass aClass;
                    String annotation = ruleAnnotated ? JUnitRuleInspection.RULE_FQN : JUnitRuleInspection.CLASS_RULE_FQN;
                    String errorMessage = JUnitRuleInspection.getPublicStaticErrorMessage((PsiModifierListOwner)field, ruleAnnotated, classRuleAnnotated);
                    if (errorMessage != null) {
                        this.registerError((PsiElement)field.getNameIdentifier(), InspectionGadgetsBundle.message("junit.rule.problem.descriptor", annotation, errorMessage), "Make field " + errorMessage, annotation);
                    }
                    if (!InheritanceUtil.isInheritor((PsiClass)(aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)field.getType())), (boolean)false, (String)"org.junit.rules.TestRule") && !InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"org.junit.rules.MethodRule")) {
                        this.registerError((PsiElement)field.getNameIdentifier(), InspectionGadgetsBundle.message("junit.rule.type.problem.descriptor", new Object[0]));
                    }
                }
            }
        };
    }

    static String getPublicStaticErrorMessage(PsiModifierListOwner field, boolean shouldBeNonStatic, boolean shouldBeStatic) {
        String errorMessage = null;
        boolean hasStatic = field.hasModifierProperty("static");
        boolean hasPublic = field.hasModifierProperty("public");
        if (!hasPublic) {
            errorMessage = shouldBeStatic ? (!hasStatic ? "public and static" : "public") : (!hasStatic ? "public" : "public and non-static");
        } else if (!hasStatic) {
            if (shouldBeStatic) {
                errorMessage = "static";
            }
        } else if (shouldBeNonStatic) {
            errorMessage = "non-static";
        }
        return errorMessage;
    }
}

