/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessarySuperQualifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.super.qualifier.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySuperQualifierInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.super.qualifier.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySuperQualifierInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarySuperQualifierFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySuperQualifierVisitor();
    }

    private static class UnnecessarySuperQualifierVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySuperQualifierVisitor() {
        }

        public void visitSuperExpression(PsiSuperExpression expression) {
            PsiMethodCallExpression methodCallExpression;
            super.visitSuperExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier != null) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiElement grandParent = referenceExpression.getParent();
            if (grandParent instanceof PsiMethodCallExpression ? !UnnecessarySuperQualifierVisitor.hasUnnecessarySuperQualifier(methodCallExpression = (PsiMethodCallExpression)grandParent) : !UnnecessarySuperQualifierVisitor.hasUnnecessarySuperQualifier(referenceExpression)) {
                return;
            }
            this.registerError((PsiElement)expression, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private static boolean hasUnnecessarySuperQualifier(PsiReferenceExpression referenceExpression) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            if (parentClass == null) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField superField = (PsiField)target;
            PsiReferenceExpression copy = (PsiReferenceExpression)referenceExpression.copy();
            PsiElement qualifier = copy.getQualifier();
            if (qualifier == null) {
                return false;
            }
            qualifier.delete();
            return superField == copy.resolve();
        }

        private static boolean hasUnnecessarySuperQualifier(PsiMethodCallExpression methodCallExpression) {
            PsiMethod superMethod = methodCallExpression.resolveMethod();
            if (superMethod == null) {
                return false;
            }
            PsiMethodCallExpression copy = (PsiMethodCallExpression)methodCallExpression.copy();
            PsiReferenceExpression methodExpression = copy.getMethodExpression();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return false;
            }
            qualifier.delete();
            return superMethod == copy.resolveMethod();
        }
    }

    private static class UnnecessarySuperQualifierFix
    extends InspectionGadgetsFix {
        private UnnecessarySuperQualifierFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySuperQualifierInspection$UnnecessarySuperQualifierFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.super.qualifier.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySuperQualifierInspection$UnnecessarySuperQualifierFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            element.delete();
        }
    }
}

