/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.chartostring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.chartostring.CharToStringPredicate;
import org.jetbrains.annotations.NotNull;

public class CharToStringIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        CharToStringPredicate charToStringPredicate = new CharToStringPredicate();
        if (charToStringPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/chartostring/CharToStringIntention", "getElementPredicate"));
        }
        return charToStringPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/chartostring/CharToStringIntention", "processIntention"));
        }
        PsiLiteralExpression charLiteral = (PsiLiteralExpression)element;
        String charLiteralText = charLiteral.getText();
        String stringLiteral = CharToStringIntention.stringForCharLiteral(charLiteralText);
        PsiReplacementUtil.replaceExpression((PsiExpression)charLiteral, stringLiteral);
    }

    private static String stringForCharLiteral(String charLiteral) {
        if ("'\"'".equals(charLiteral)) {
            return "\"\\\"\"";
        }
        if ("'\\''".equals(charLiteral)) {
            return "\"'\"";
        }
        return '\"' + charLiteral.substring(1, charLiteral.length() - 1) + '\"';
    }
}

